/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.proxy.RejectedProxyUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.springframework.core.task.TaskDecorator;

public class DynamicThreadPoolExecutor
extends AbstractDynamicExecutorSupport {
    private Long executeTimeOut;
    private TaskDecorator taskDecorator;
    private RejectedExecutionHandler redundancyHandler;
    private final String threadPoolId;
    private final AtomicLong rejectCount = new AtomicLong();
    private final ThreadLocal<Long> startTime = new ThreadLocal();

    public DynamicThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, long executeTimeOut, boolean waitForTasksToCompleteOnShutdown, long awaitTerminationMillis, @NonNull BlockingQueue<Runnable> workQueue, @NonNull String threadPoolId, @NonNull ThreadFactory threadFactory, @NonNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, waitForTasksToCompleteOnShutdown, awaitTerminationMillis, workQueue, threadPoolId, threadFactory, handler);
        if (workQueue == null) {
            throw new NullPointerException("workQueue is marked non-null but is null");
        }
        if (threadPoolId == null) {
            throw new NullPointerException("threadPoolId is marked non-null but is null");
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.threadPoolId = threadPoolId;
        this.executeTimeOut = executeTimeOut;
        RejectedExecutionHandler rejectedProxy = RejectedProxyUtil.createProxy(handler, threadPoolId, this.rejectCount);
        this.setRejectedExecutionHandler(rejectedProxy);
        this.redundancyHandler = handler;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (this.taskDecorator != null) {
            command = this.taskDecorator.decorate(command);
        }
        super.execute(command);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.executeTimeOut == null || this.executeTimeOut <= 0L) {
            return;
        }
        this.startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (this.executeTimeOut == null || this.executeTimeOut <= 0L) {
            return;
        }
        try {
            ThreadPoolNotifyAlarmHandler notifyAlarmHandler;
            boolean executeTimeAlarm;
            long startTime = this.startTime.get();
            long endTime = System.currentTimeMillis();
            long executeTime = endTime - startTime;
            boolean bl = executeTimeAlarm = executeTime > this.executeTimeOut;
            if (executeTimeAlarm && ApplicationContextHolder.getInstance() != null && (notifyAlarmHandler = (ThreadPoolNotifyAlarmHandler)ApplicationContextHolder.getBean(ThreadPoolNotifyAlarmHandler.class)) != null) {
                notifyAlarmHandler.asyncSendExecuteTimeOutAlarm(this.threadPoolId, executeTime, this.executeTimeOut, this);
            }
        }
        finally {
            this.startTime.remove();
        }
    }

    @Override
    protected ExecutorService initializeExecutor() {
        return this;
    }

    public Long getRejectCountNum() {
        return this.rejectCount.get();
    }

    public Long getExecuteTimeOut() {
        return this.executeTimeOut;
    }

    public void setExecuteTimeOut(Long executeTimeOut) {
        this.executeTimeOut = executeTimeOut;
    }

    public TaskDecorator getTaskDecorator() {
        return this.taskDecorator;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public RejectedExecutionHandler getRedundancyHandler() {
        return this.redundancyHandler;
    }

    public void setRedundancyHandler(RejectedExecutionHandler redundancyHandler) {
        this.redundancyHandler = redundancyHandler;
    }

    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    public AtomicLong getRejectCount() {
        return this.rejectCount;
    }
}

