/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.support;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.executor.DynamicThreadPool;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.CommonDynamicThreadPool;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapterChoose;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.config.DynamicThreadPoolNotifyProperties;
import cn.hippo4j.core.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.core.springboot.starter.support.GlobalCoreThreadPoolManage;
import cn.hippo4j.core.toolkit.inet.DynamicThreadPoolAnnotationUtil;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.task.TaskDecorator;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapCoreProperties bootstrapCoreProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor || DynamicThreadPoolAdapterChoose.match((Object)bean)) {
            try {
                DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
                if (Objects.isNull(dynamicThreadPool) && Objects.isNull(dynamicThreadPool = (DynamicThreadPool)DynamicThreadPoolAnnotationUtil.findAnnotationOnBean((String)beanName, DynamicThreadPool.class))) {
                    return bean;
                }
            }
            catch (Exception ex) {
                log.error("Failed to create dynamic thread pool in annotation mode.", (Throwable)ex);
                return bean;
            }
            DynamicThreadPoolExecutor dynamicThreadPoolExecutor = DynamicThreadPoolAdapterChoose.unwrap((Object)bean);
            if (dynamicThreadPoolExecutor == null) {
                dynamicThreadPoolExecutor = (DynamicThreadPoolExecutor)bean;
            }
            DynamicThreadPoolWrapper wrap = new DynamicThreadPoolWrapper(dynamicThreadPoolExecutor.getThreadPoolId(), (ThreadPoolExecutor)dynamicThreadPoolExecutor);
            ThreadPoolExecutor remoteThreadPoolExecutor = this.fillPoolAndRegister(wrap);
            DynamicThreadPoolAdapterChoose.replace((Object)bean, (Executor)remoteThreadPoolExecutor);
            return remoteThreadPoolExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper wrap = (DynamicThreadPoolWrapper)bean;
            this.registerAndSubscribe(wrap);
        }
        return bean;
    }

    protected void registerAndSubscribe(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        this.fillPoolAndRegister(dynamicThreadPoolWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        String threadPoolId = dynamicThreadPoolWrapper.getThreadPoolId();
        ThreadPoolExecutor newDynamicPoolExecutor = dynamicThreadPoolWrapper.getExecutor();
        ExecutorProperties executorProperties = null;
        if (null != this.bootstrapCoreProperties.getExecutors()) {
            executorProperties = this.bootstrapCoreProperties.getExecutors().stream().filter(each -> Objects.equals(threadPoolId, each.getThreadPoolId())).findFirst().orElse(null);
            if (executorProperties != null) {
                try {
                    BlockingQueue workQueue = QueueTypeEnum.createBlockingQueue((String)executorProperties.getBlockingQueue(), (Integer)executorProperties.getQueueCapacity());
                    String threadNamePrefix = executorProperties.getThreadNamePrefix();
                    newDynamicPoolExecutor = ThreadPoolBuilder.builder().dynamicPool().workQueue(workQueue).threadFactory(StringUtil.isNotBlank((CharSequence)threadNamePrefix) ? threadNamePrefix : threadPoolId).executeTimeOut(Optional.ofNullable(executorProperties.getExecuteTimeOut()).orElse(0L).longValue()).poolThreadSize(executorProperties.getCorePoolSize().intValue(), executorProperties.getMaximumPoolSize().intValue()).keepAliveTime(executorProperties.getKeepAliveTime().longValue(), TimeUnit.SECONDS).rejected(RejectedTypeEnum.createPolicy((String)executorProperties.getRejectedHandler())).allowCoreThreadTimeOut(executorProperties.getAllowCoreThreadTimeOut().booleanValue()).build();
                }
                catch (Exception ex) {
                    log.error("Failed to initialize thread pool configuration. error: {}", (Throwable)ex);
                }
                finally {
                    if (Objects.isNull(dynamicThreadPoolWrapper.getExecutor())) {
                        dynamicThreadPoolWrapper.setExecutor((ThreadPoolExecutor)CommonDynamicThreadPool.getInstance((String)threadPoolId));
                    }
                    dynamicThreadPoolWrapper.setInitFlag(Boolean.TRUE.booleanValue());
                }
            }
            if (dynamicThreadPoolWrapper.getExecutor() instanceof AbstractDynamicExecutorSupport) {
                DynamicThreadPoolNotifyProperties notify = Optional.ofNullable(executorProperties).map(ExecutorProperties::getNotify).orElse(null);
                boolean isAlarm = Optional.ofNullable(this.bootstrapCoreProperties.getAlarm()).orElseGet(() -> this.bootstrapCoreProperties.getAlarm() != null ? this.bootstrapCoreProperties.getAlarm() : true);
                int activeAlarm = Optional.ofNullable(this.bootstrapCoreProperties.getActiveAlarm()).orElseGet(() -> this.bootstrapCoreProperties.getActiveAlarm() != null ? this.bootstrapCoreProperties.getActiveAlarm() : 80);
                int capacityAlarm = Optional.ofNullable(this.bootstrapCoreProperties.getCapacityAlarm()).orElseGet(() -> this.bootstrapCoreProperties.getCapacityAlarm() != null ? this.bootstrapCoreProperties.getCapacityAlarm() : 80);
                int interval = Optional.ofNullable(notify).map(each -> each.getInterval()).orElseGet(() -> this.bootstrapCoreProperties.getAlarmInterval() != null ? this.bootstrapCoreProperties.getAlarmInterval() : 5);
                String receive = Optional.ofNullable(notify).map(each -> each.getReceives()).orElseGet(() -> this.bootstrapCoreProperties.getReceives() != null ? this.bootstrapCoreProperties.getReceives() : null);
                ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(isAlarm), Integer.valueOf(activeAlarm), Integer.valueOf(capacityAlarm));
                threadPoolNotifyAlarm.setInterval(Integer.valueOf(interval));
                threadPoolNotifyAlarm.setReceives(receive);
                GlobalNotifyAlarmManage.put((String)threadPoolId, (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
                TaskDecorator taskDecorator = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).getTaskDecorator();
                ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setTaskDecorator(taskDecorator);
                long awaitTerminationMillis = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).awaitTerminationMillis;
                boolean waitForTasksToCompleteOnShutdown = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrapper.getExecutor()).waitForTasksToCompleteOnShutdown;
                ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setSupportParam(awaitTerminationMillis, waitForTasksToCompleteOnShutdown);
            }
            dynamicThreadPoolWrapper.setExecutor(newDynamicPoolExecutor);
        }
        GlobalThreadPoolManage.registerPool((String)dynamicThreadPoolWrapper.getThreadPoolId(), (DynamicThreadPoolWrapper)dynamicThreadPoolWrapper);
        GlobalCoreThreadPoolManage.register(threadPoolId, executorProperties == null ? this.buildExecutorProperties(threadPoolId, newDynamicPoolExecutor) : executorProperties);
        return newDynamicPoolExecutor;
    }

    private ExecutorProperties buildExecutorProperties(String threadPoolId, ThreadPoolExecutor executor) {
        ExecutorProperties executorProperties = new ExecutorProperties();
        BlockingQueue<Runnable> blockingQueue = executor.getQueue();
        int queueSize = blockingQueue.size();
        String queueType = blockingQueue.getClass().getSimpleName();
        int remainingCapacity = blockingQueue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        executorProperties.setCorePoolSize(executor.getCorePoolSize()).setMaximumPoolSize(executor.getMaximumPoolSize()).setAllowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut()).setKeepAliveTime(executor.getKeepAliveTime(TimeUnit.SECONDS)).setBlockingQueue(queueType).setExecuteTimeOut(10000L).setQueueCapacity(queueCapacity).setRejectedHandler(((DynamicThreadPoolExecutor)executor).getRedundancyHandler().getClass().getSimpleName()).setThreadPoolId(threadPoolId);
        return executorProperties;
    }

    public DynamicThreadPoolPostProcessor(BootstrapCoreProperties bootstrapCoreProperties) {
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

