/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.support;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.springboot.starter.config.AdapterExecutorProperties;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class DynamicThreadPoolAdapterRegister
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolAdapterRegister.class);
    private final BootstrapCoreProperties bootstrapCoreProperties;
    public static final Map<String, AdapterExecutorProperties> ADAPTER_EXECUTORS_MAP = Maps.newConcurrentMap();

    public void run(ApplicationArguments args) throws Exception {
        List<AdapterExecutorProperties> adapterExecutors = this.bootstrapCoreProperties.getAdapterExecutors();
        if (CollectionUtil.isEmpty(adapterExecutors)) {
            return;
        }
        for (AdapterExecutorProperties each : adapterExecutors) {
            String buildKey = each.getMark() + "_" + each.getThreadPoolKey();
            ADAPTER_EXECUTORS_MAP.put(buildKey, each);
        }
    }

    public DynamicThreadPoolAdapterRegister(BootstrapCoreProperties bootstrapCoreProperties) {
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

