/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.refresher.event;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.core.springboot.starter.notify.CoreNotifyConfigBuilder;
import cn.hippo4j.core.springboot.starter.refresher.event.Hippo4jCoreDynamicRefreshEvent;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.service.Hippo4jBaseSendMessageService;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=1)
public class PlatformsRefreshListener
implements ApplicationListener<Hippo4jCoreDynamicRefreshEvent> {
    public void onApplicationEvent(Hippo4jCoreDynamicRefreshEvent threadPoolDynamicRefreshEvent) {
        BootstrapCoreProperties bindableCoreProperties = threadPoolDynamicRefreshEvent.getBootstrapCoreProperties();
        List<ExecutorProperties> executors = bindableCoreProperties.getExecutors();
        for (ExecutorProperties executorProperties : executors) {
            String threadPoolId = executorProperties.getThreadPoolId();
            DynamicThreadPoolWrapper wrapper = GlobalThreadPoolManage.getExecutorService((String)threadPoolId);
            if (wrapper == null || wrapper.isInitFlag()) continue;
            Hippo4jBaseSendMessageService sendMessageService = (Hippo4jBaseSendMessageService)ApplicationContextHolder.getBean(Hippo4jBaseSendMessageService.class);
            CoreNotifyConfigBuilder configBuilder = (CoreNotifyConfigBuilder)ApplicationContextHolder.getBean(CoreNotifyConfigBuilder.class);
            Map<String, List<NotifyConfigDTO>> notifyConfig = configBuilder.buildSingleNotifyConfig(executorProperties);
            sendMessageService.putPlatform(notifyConfig);
            wrapper.setInitFlag(Boolean.TRUE.booleanValue());
        }
    }
}

