/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.refresher.event;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ResizableCapacityLinkedBlockingQueue;
import cn.hippo4j.core.proxy.RejectedProxyUtil;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.core.springboot.starter.notify.CoreNotifyConfigBuilder;
import cn.hippo4j.core.springboot.starter.refresher.event.Hippo4jCoreDynamicRefreshEvent;
import cn.hippo4j.core.springboot.starter.support.GlobalCoreThreadPoolManage;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.Hippo4jBaseSendMessageService;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=2)
public class DynamicThreadPoolRefreshListener
implements ApplicationListener<Hippo4jCoreDynamicRefreshEvent> {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolRefreshListener.class);
    private final ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler;
    private final CoreNotifyConfigBuilder coreNotifyConfigBuilder;
    private final Hippo4jBaseSendMessageService hippo4jBaseSendMessageService;

    public void onApplicationEvent(Hippo4jCoreDynamicRefreshEvent threadPoolDynamicRefreshEvent) {
        BootstrapCoreProperties bindableCoreProperties = threadPoolDynamicRefreshEvent.getBootstrapCoreProperties();
        List<ExecutorProperties> executors = bindableCoreProperties.getExecutors();
        for (ExecutorProperties properties : executors) {
            String threadPoolId = properties.getThreadPoolId();
            this.checkNotifyConsistencyAndReplace(properties);
            if (!this.checkConsistency(threadPoolId, properties)) continue;
            this.dynamicRefreshPool(threadPoolId, properties);
            ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
            GlobalCoreThreadPoolManage.refresh(threadPoolId, properties);
            log.info("Dynamic thread pool change parameter: [{}]\n    corePoolSize: [{}]\n    maximumPoolSize: [{}]\n    capacity: [{}]\n    keepAliveTime: [{}]\n    executeTimeOut: [{}]\n    rejectedType: [{}]\n    allowCoreThreadTimeOut: [{}]", new Object[]{threadPoolId, String.format("%s => %s", beforeProperties.getCorePoolSize(), properties.getCorePoolSize()), String.format("%s => %s", beforeProperties.getMaximumPoolSize(), properties.getMaximumPoolSize()), String.format("%s => %s", beforeProperties.getQueueCapacity(), properties.getQueueCapacity()), String.format("%s => %s", beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime()), String.format("%s => %s", beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()), String.format("%s => %s", beforeProperties.getRejectedHandler(), properties.getRejectedHandler()), String.format("%s => %s", beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut())});
            try {
                this.threadPoolNotifyAlarmHandler.sendPoolConfigChange(this.newChangeRequest(beforeProperties, properties));
            }
            catch (Throwable ex) {
                log.error("Failed to send Chang smart application listener notice. Message: {}", (Object)ex.getMessage());
            }
        }
    }

    private ChangeParameterNotifyRequest newChangeRequest(ExecutorProperties beforeProperties, ExecutorProperties properties) {
        ChangeParameterNotifyRequest changeParameterNotifyRequest = ChangeParameterNotifyRequest.builder().beforeCorePoolSize(beforeProperties.getCorePoolSize()).beforeMaximumPoolSize(beforeProperties.getMaximumPoolSize()).beforeAllowsCoreThreadTimeOut(beforeProperties.getAllowCoreThreadTimeOut()).beforeKeepAliveTime(beforeProperties.getKeepAliveTime()).blockingQueueName(beforeProperties.getBlockingQueue()).beforeQueueCapacity(beforeProperties.getQueueCapacity()).beforeRejectedName(beforeProperties.getRejectedHandler()).beforeExecuteTimeOut(beforeProperties.getExecuteTimeOut()).nowCorePoolSize(properties.getCorePoolSize()).nowMaximumPoolSize(properties.getMaximumPoolSize()).nowAllowsCoreThreadTimeOut(properties.getAllowCoreThreadTimeOut()).nowKeepAliveTime(properties.getKeepAliveTime()).nowQueueCapacity(properties.getQueueCapacity()).nowRejectedName(properties.getRejectedHandler()).nowExecuteTimeOut(properties.getExecuteTimeOut()).build();
        changeParameterNotifyRequest.setThreadPoolId(beforeProperties.getThreadPoolId());
        return changeParameterNotifyRequest;
    }

    private void checkNotifyConsistencyAndReplace(ExecutorProperties properties) {
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm;
        boolean checkNotifyConfig = false;
        boolean checkNotifyAlarm = false;
        ArrayList changeKeys = Lists.newArrayList();
        Map<String, List<NotifyConfigDTO>> newDynamicThreadPoolNotifyMap = this.coreNotifyConfigBuilder.buildSingleNotifyConfig(properties);
        Map notifyConfigs = this.hippo4jBaseSendMessageService.getNotifyConfigs();
        if (CollectionUtil.isNotEmpty((Map)notifyConfigs)) {
            block0: for (Map.Entry<String, List<NotifyConfigDTO>> each : newDynamicThreadPoolNotifyMap.entrySet()) {
                if (checkNotifyConfig) break;
                List notifyConfigDTOS = (List)notifyConfigs.get(each.getKey());
                for (NotifyConfigDTO notifyConfig : each.getValue()) {
                    if (notifyConfigDTOS.contains(notifyConfig)) continue;
                    checkNotifyConfig = true;
                    changeKeys.add(each.getKey());
                    continue block0;
                }
            }
        }
        if (checkNotifyConfig) {
            this.coreNotifyConfigBuilder.initCacheAndLock(newDynamicThreadPoolNotifyMap);
            this.hippo4jBaseSendMessageService.putPlatform(newDynamicThreadPoolNotifyMap);
        }
        if ((threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get((String)properties.getThreadPoolId())) != null) {
            boolean isAlarm = properties.getAlarm();
            Integer activeAlarm = properties.getActiveAlarm();
            Integer capacityAlarm = properties.getCapacityAlarm();
            if (threadPoolNotifyAlarm.getAlarm() != isAlarm || threadPoolNotifyAlarm.getActiveAlarm() != activeAlarm || threadPoolNotifyAlarm.getCapacityAlarm() != capacityAlarm) {
                checkNotifyAlarm = true;
                threadPoolNotifyAlarm.setAlarm(Boolean.valueOf(isAlarm));
                threadPoolNotifyAlarm.setActiveAlarm(activeAlarm);
                threadPoolNotifyAlarm.setCapacityAlarm(capacityAlarm);
            }
        }
        if (checkNotifyConfig || checkNotifyAlarm) {
            log.info("[{}] Dynamic thread pool notification property changes.", (Object)properties.getThreadPoolId());
        }
    }

    private boolean checkConsistency(String threadPoolId, ExecutorProperties properties) {
        ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutor((String)threadPoolId);
        if (executor == null) {
            return false;
        }
        boolean result = !Objects.equals(beforeProperties.getCorePoolSize(), properties.getCorePoolSize()) || !Objects.equals(beforeProperties.getMaximumPoolSize(), properties.getMaximumPoolSize()) || !Objects.equals(beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut()) || !Objects.equals(beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()) || !Objects.equals(beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime()) || !Objects.equals(beforeProperties.getRejectedHandler(), properties.getRejectedHandler()) || !Objects.equals(beforeProperties.getQueueCapacity(), properties.getQueueCapacity()) && Objects.equals(QueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.name, executor.getQueue().getClass().getSimpleName());
        return result;
    }

    private void dynamicRefreshPool(String threadPoolId, ExecutorProperties properties) {
        ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        if (properties.getMaximumPoolSize() != null && properties.getCorePoolSize() != null) {
            if (properties.getMaximumPoolSize() < executor.getMaximumPoolSize()) {
                executor.setCorePoolSize(properties.getCorePoolSize());
                executor.setMaximumPoolSize(properties.getMaximumPoolSize());
            } else {
                executor.setMaximumPoolSize(properties.getMaximumPoolSize());
                executor.setCorePoolSize(properties.getCorePoolSize());
            }
        } else {
            if (properties.getMaximumPoolSize() != null) {
                executor.setMaximumPoolSize(properties.getMaximumPoolSize());
            }
            if (properties.getCorePoolSize() != null) {
                executor.setCorePoolSize(properties.getCorePoolSize());
            }
        }
        if (!Objects.equals(beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut())) {
            executor.allowCoreThreadTimeOut(properties.getAllowCoreThreadTimeOut());
        }
        if (!Objects.equals(beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()) && executor instanceof AbstractDynamicExecutorSupport) {
            ((DynamicThreadPoolExecutor)executor).setExecuteTimeOut(properties.getExecuteTimeOut());
        }
        if (!Objects.equals(beforeProperties.getRejectedHandler(), properties.getRejectedHandler())) {
            RejectedExecutionHandler rejectedExecutionHandler = RejectedTypeEnum.createPolicy((String)properties.getRejectedHandler());
            if (executor instanceof AbstractDynamicExecutorSupport) {
                DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)executor;
                dynamicExecutor.setRedundancyHandler(rejectedExecutionHandler);
                AtomicLong rejectCount = dynamicExecutor.getRejectCount();
                rejectedExecutionHandler = RejectedProxyUtil.createProxy((RejectedExecutionHandler)rejectedExecutionHandler, (String)threadPoolId, (AtomicLong)rejectCount);
            }
            executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        }
        if (!Objects.equals(beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime())) {
            executor.setKeepAliveTime(properties.getKeepAliveTime(), TimeUnit.SECONDS);
        }
        if (!Objects.equals(beforeProperties.getQueueCapacity(), properties.getQueueCapacity()) && Objects.equals(QueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.name, executor.getQueue().getClass().getSimpleName())) {
            if (executor.getQueue() instanceof ResizableCapacityLinkedBlockingQueue) {
                ResizableCapacityLinkedBlockingQueue queue = (ResizableCapacityLinkedBlockingQueue)executor.getQueue();
                queue.setCapacity(properties.getQueueCapacity());
            } else {
                log.warn("The queue length cannot be modified. Queue type mismatch. Current queue type: {}", (Object)executor.getQueue().getClass().getSimpleName());
            }
        }
    }

    public DynamicThreadPoolRefreshListener(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, CoreNotifyConfigBuilder coreNotifyConfigBuilder, Hippo4jBaseSendMessageService hippo4jBaseSendMessageService) {
        this.threadPoolNotifyAlarmHandler = threadPoolNotifyAlarmHandler;
        this.coreNotifyConfigBuilder = coreNotifyConfigBuilder;
        this.hippo4jBaseSendMessageService = hippo4jBaseSendMessageService;
    }
}

