/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.refresher.event;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.springboot.starter.config.AdapterExecutorProperties;
import cn.hippo4j.core.springboot.starter.refresher.event.Hippo4jCoreDynamicRefreshEvent;
import cn.hippo4j.core.springboot.starter.support.DynamicThreadPoolAdapterRegister;
import cn.hutool.core.bean.BeanUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=3)
public class AdapterExecutorsRefreshListener
implements ApplicationListener<Hippo4jCoreDynamicRefreshEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdapterExecutorsRefreshListener.class);

    public void onApplicationEvent(Hippo4jCoreDynamicRefreshEvent event) {
        Map threadPoolAdapterMap = ApplicationContextHolder.getBeansOfType(ThreadPoolAdapter.class);
        List<AdapterExecutorProperties> adapterExecutors = event.getBootstrapCoreProperties().getAdapterExecutors();
        if (CollectionUtil.isEmpty(adapterExecutors) || CollectionUtil.isEmpty((Map)threadPoolAdapterMap)) {
            return;
        }
        for (AdapterExecutorProperties each : adapterExecutors) {
            String buildKey = each.getMark() + "_" + each.getThreadPoolKey();
            AdapterExecutorProperties adapterExecutorProperties = DynamicThreadPoolAdapterRegister.ADAPTER_EXECUTORS_MAP.get(buildKey);
            if (adapterExecutorProperties == null || Objects.equals(adapterExecutorProperties.getCorePoolSize(), each.getCorePoolSize()) && Objects.equals(adapterExecutorProperties.getMaximumPoolSize(), each.getMaximumPoolSize())) continue;
            threadPoolAdapterMap.forEach((key, val) -> {
                if (Objects.equals(val.mark(), each.getMark())) {
                    val.updateThreadPool((ThreadPoolAdapterParameter)BeanUtil.toBean((Object)each, ThreadPoolAdapterParameter.class));
                    DynamicThreadPoolAdapterRegister.ADAPTER_EXECUTORS_MAP.put(buildKey, each);
                }
            });
        }
    }
}

