/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.refresher;

import cn.hippo4j.core.springboot.starter.refresher.AbstractCoreThreadPoolDynamicRefresh;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ApolloRefresherHandler
extends AbstractCoreThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(ApolloRefresherHandler.class);
    private static final String APOLLO_PROPERTY = "${spring.dynamic.thread-pool.apollo.namespace:application}";
    @Value(value="${spring.dynamic.thread-pool.apollo.namespace:application}")
    private String namespace;

    public void afterPropertiesSet() {
        String[] apolloNamespaces = this.namespace.split(",");
        this.namespace = apolloNamespaces[0];
        Config config = ConfigService.getConfig((String)String.format("%s.%s", this.namespace, this.bootstrapCoreProperties.getConfigFileType().getValue()));
        ConfigChangeListener configChangeListener = configChangeEvent -> {
            String namespace = this.namespace.replaceAll("." + this.bootstrapCoreProperties.getConfigFileType().getValue(), "");
            ConfigFileFormat configFileFormat = ConfigFileFormat.fromString((String)this.bootstrapCoreProperties.getConfigFileType().getValue());
            ConfigFile configFile = ConfigService.getConfigFile((String)namespace, (ConfigFileFormat)configFileFormat);
            HashMap newChangeValueMap = Maps.newHashMap();
            configChangeEvent.changedKeys().stream().filter(each -> each.contains("spring.dynamic.thread-pool")).forEach(each -> {
                ConfigChange change = configChangeEvent.getChange(each);
                String newValue = change.getNewValue();
                newChangeValueMap.put(each, newValue);
            });
            this.dynamicRefresh(configFile.getContent(), newChangeValueMap);
        };
        config.addChangeListener(configChangeListener);
        log.info("Dynamic thread pool refresher, add apollo listener success. namespace: {}", (Object)this.namespace);
    }
}

