/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.refresher;

import cn.hippo4j.common.api.ThreadPoolDynamicRefresh;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.parser.ConfigParserHandler;
import cn.hippo4j.core.springboot.starter.refresher.BootstrapCorePropertiesBinderAdapt;
import cn.hippo4j.core.springboot.starter.refresher.event.Hippo4jCoreDynamicRefreshEvent;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractCoreThreadPoolDynamicRefresh
implements ThreadPoolDynamicRefresh,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractCoreThreadPoolDynamicRefresh.class);
    protected final BootstrapCoreProperties bootstrapCoreProperties;
    protected final ExecutorService dynamicRefreshExecutorService = ThreadPoolBuilder.builder().singlePool("client.dynamic.refresh").build();

    public AbstractCoreThreadPoolDynamicRefresh() {
        this.bootstrapCoreProperties = (BootstrapCoreProperties)ApplicationContextHolder.getBean(BootstrapCoreProperties.class);
    }

    public void dynamicRefresh(String configContent) {
        this.dynamicRefresh(configContent, null);
    }

    public void dynamicRefresh(String configContent, Map<String, Object> newValueChangeMap) {
        try {
            Map<Object, Object> configInfo = ConfigParserHandler.getInstance().parseConfig(configContent, this.bootstrapCoreProperties.getConfigFileType());
            if (CollectionUtil.isNotEmpty(newValueChangeMap)) {
                Optional.ofNullable(configInfo).ifPresent(each -> each.putAll(newValueChangeMap));
            }
            BootstrapCoreProperties bindableCoreProperties = BootstrapCorePropertiesBinderAdapt.bootstrapCorePropertiesBinder(configInfo, this.bootstrapCoreProperties);
            ApplicationContextHolder.getInstance().publishEvent((ApplicationEvent)new Hippo4jCoreDynamicRefreshEvent(this, bindableCoreProperties));
        }
        catch (Exception ex) {
            log.error("Hippo-4J core dynamic refresh failed.", (Throwable)ex);
        }
    }

    public AbstractCoreThreadPoolDynamicRefresh(BootstrapCoreProperties bootstrapCoreProperties) {
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

