/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.parser;

import cn.hippo4j.core.springboot.starter.parser.ConfigFileTypeEnum;
import cn.hippo4j.core.springboot.starter.parser.ConfigParser;
import cn.hippo4j.core.springboot.starter.parser.PropertiesConfigParser;
import cn.hippo4j.core.springboot.starter.parser.YamlConfigParser;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class ConfigParserHandler {
    private static final List<ConfigParser> PARSERS = Lists.newArrayList();

    private ConfigParserHandler() {
        ServiceLoader<ConfigParser> loader = ServiceLoader.load(ConfigParser.class);
        for (ConfigParser configParser : loader) {
            PARSERS.add(configParser);
        }
        PARSERS.add(new PropertiesConfigParser());
        PARSERS.add(new YamlConfigParser());
    }

    public Map<Object, Object> parseConfig(String content, ConfigFileTypeEnum type) throws IOException {
        for (ConfigParser parser : PARSERS) {
            if (!parser.supports(type)) continue;
            return parser.doParse(content);
        }
        return Collections.emptyMap();
    }

    public static ConfigParserHandler getInstance() {
        return ConfigParserHandlerHolder.INSTANCE;
    }

    private static class ConfigParserHandlerHolder {
        private static final ConfigParserHandler INSTANCE = new ConfigParserHandler();

        private ConfigParserHandlerHolder() {
        }
    }
}

