/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.notify;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.core.springboot.starter.config.NotifyPlatformProperties;
import cn.hippo4j.message.api.NotifyConfigBuilder;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.service.AlarmControlHandler;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreNotifyConfigBuilder
implements NotifyConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(CoreNotifyConfigBuilder.class);
    private final AlarmControlHandler alarmControlHandler;
    private final BootstrapCoreProperties bootstrapCoreProperties;

    public Map<String, List<NotifyConfigDTO>> buildNotify() {
        HashMap resultMap = Maps.newHashMap();
        boolean globalAlarm = this.bootstrapCoreProperties.getAlarm();
        List<ExecutorProperties> executors = this.bootstrapCoreProperties.getExecutors();
        if (CollectionUtil.isEmpty(executors)) {
            log.warn("Failed to build notify, executors configuration is empty.");
            return resultMap;
        }
        List actual = executors.stream().filter(each -> Optional.ofNullable(each.getAlarm()).orElse(false)).collect(Collectors.toList());
        if (!globalAlarm && CollectionUtil.isEmpty(actual)) {
            return resultMap;
        }
        for (ExecutorProperties executor : executors) {
            Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig = this.buildSingleNotifyConfig(executor);
            this.initCacheAndLock(buildSingleNotifyConfig);
            resultMap.putAll(buildSingleNotifyConfig);
        }
        return resultMap;
    }

    public Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig(ExecutorProperties executor) {
        HashMap resultMap = Maps.newHashMap();
        String threadPoolId = executor.getThreadPoolId();
        String alarmBuildKey = threadPoolId + "+ALARM";
        ArrayList alarmNotifyConfigs = Lists.newArrayList();
        List<NotifyPlatformProperties> notifyPlatforms = this.bootstrapCoreProperties.getNotifyPlatforms();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setTpId(threadPoolId);
            notifyConfig.setType("ALARM");
            notifyConfig.setSecret(platformProperties.getSecret());
            notifyConfig.setSecretKey(this.getToken(platformProperties));
            int interval = Optional.ofNullable(executor.getNotify()).map(each -> each.getInterval()).orElseGet(() -> this.bootstrapCoreProperties.getAlarmInterval() != null ? this.bootstrapCoreProperties.getAlarmInterval() : 5);
            notifyConfig.setInterval(Integer.valueOf(interval));
            notifyConfig.setReceives(this.buildReceive(executor, platformProperties));
            alarmNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(alarmBuildKey, alarmNotifyConfigs);
        String changeBuildKey = threadPoolId + "+CONFIG";
        ArrayList changeNotifyConfigs = Lists.newArrayList();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setTpId(threadPoolId);
            notifyConfig.setType("CONFIG");
            notifyConfig.setSecretKey(this.getToken(platformProperties));
            notifyConfig.setSecret(platformProperties.getSecret());
            notifyConfig.setReceives(this.buildReceive(executor, platformProperties));
            changeNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(changeBuildKey, changeNotifyConfigs);
        return resultMap;
    }

    public void initCacheAndLock(Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig) {
        buildSingleNotifyConfig.forEach((key, val) -> val.stream().filter(each -> StrUtil.equals((CharSequence)"ALARM", (CharSequence)each.getType())).forEach(each -> this.alarmControlHandler.initCacheAndLock(each.getTpId(), each.getPlatform(), each.getInterval())));
    }

    private String buildReceive(ExecutorProperties executor, NotifyPlatformProperties platformProperties) {
        String receive;
        if (executor.getNotify() != null) {
            receive = executor.getNotify().getReceives();
            if (StrUtil.isBlank((CharSequence)receive)) {
                receive = this.bootstrapCoreProperties.getReceives();
            }
        } else {
            receive = this.bootstrapCoreProperties.getReceives();
        }
        return receive;
    }

    private String getToken(NotifyPlatformProperties platformProperties) {
        return StringUtil.isNotBlank((CharSequence)platformProperties.getToken()) ? platformProperties.getToken() : platformProperties.getSecretKey();
    }

    public CoreNotifyConfigBuilder(AlarmControlHandler alarmControlHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        this.alarmControlHandler = alarmControlHandler;
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

