/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.config;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.config.BootstrapPropertiesInterface;
import cn.hippo4j.core.config.UtilAutoConfiguration;
import cn.hippo4j.core.enable.MarkerConfiguration;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.handler.DynamicThreadPoolBannerHandler;
import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.config.ConfigHandlerConfiguration;
import cn.hippo4j.core.springboot.starter.monitor.DynamicThreadPoolMonitorExecutor;
import cn.hippo4j.core.springboot.starter.notify.CoreNotifyConfigBuilder;
import cn.hippo4j.core.springboot.starter.refresher.event.AdapterExecutorsRefreshListener;
import cn.hippo4j.core.springboot.starter.refresher.event.DynamicThreadPoolRefreshListener;
import cn.hippo4j.core.springboot.starter.refresher.event.PlatformsRefreshListener;
import cn.hippo4j.core.springboot.starter.refresher.event.WebExecutorRefreshListener;
import cn.hippo4j.core.springboot.starter.support.DynamicThreadPoolAdapterRegister;
import cn.hippo4j.core.springboot.starter.support.DynamicThreadPoolConfigService;
import cn.hippo4j.core.springboot.starter.support.DynamicThreadPoolPostProcessor;
import cn.hippo4j.message.api.NotifyConfigBuilder;
import cn.hippo4j.message.config.MessageConfiguration;
import cn.hippo4j.message.service.AlarmControlHandler;
import cn.hippo4j.message.service.Hippo4jBaseSendMessageService;
import cn.hippo4j.message.service.Hippo4jSendMessageService;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnBean(value={MarkerConfiguration.Marker.class})
@EnableConfigurationProperties(value={BootstrapCoreProperties.class})
@ImportAutoConfiguration(value={UtilAutoConfiguration.class, MessageConfiguration.class})
@ConditionalOnProperty(prefix="spring.dynamic.thread-pool", value={"enable"}, matchIfMissing=true, havingValue="true")
@Import(value={ConfigHandlerConfiguration.EmbeddedNacos.class, ConfigHandlerConfiguration.EmbeddedNacosCloud.class, ConfigHandlerConfiguration.EmbeddedApollo.class, ConfigHandlerConfiguration.EmbeddedZookeeper.class})
public class DynamicThreadPoolCoreAutoConfiguration {
    private final BootstrapCoreProperties bootstrapCoreProperties;

    @Bean
    @ConditionalOnMissingBean
    @Order(value=-2147483648)
    public ApplicationContextHolder hippo4JApplicationContextHolder() {
        return new ApplicationContextHolder();
    }

    @Bean
    public NotifyConfigBuilder notifyConfigBuilder(AlarmControlHandler alarmControlHandler) {
        return new CoreNotifyConfigBuilder(alarmControlHandler, this.bootstrapCoreProperties);
    }

    @Bean
    public ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler(Hippo4jSendMessageService hippoSendMessageService) {
        return new ThreadPoolNotifyAlarmHandler(hippoSendMessageService);
    }

    @Bean
    public DynamicThreadPoolPostProcessor dynamicThreadPoolPostProcessor(ApplicationContextHolder hippo4JApplicationContextHolder) {
        return new DynamicThreadPoolPostProcessor(this.bootstrapCoreProperties);
    }

    @Bean
    public DynamicThreadPoolMonitorExecutor hippo4jDynamicThreadPoolMonitorExecutor() {
        return new DynamicThreadPoolMonitorExecutor(this.bootstrapCoreProperties);
    }

    @Bean
    public DynamicThreadPoolRefreshListener hippo4jExecutorsListener(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, CoreNotifyConfigBuilder coreNotifyConfigBuilder, Hippo4jBaseSendMessageService hippoBaseSendMessageService) {
        return new DynamicThreadPoolRefreshListener(threadPoolNotifyAlarmHandler, coreNotifyConfigBuilder, hippoBaseSendMessageService);
    }

    @Bean
    public AdapterExecutorsRefreshListener hippo4jAdapterExecutorsListener() {
        return new AdapterExecutorsRefreshListener();
    }

    @Bean
    public PlatformsRefreshListener hippo4jPlatformsListener() {
        return new PlatformsRefreshListener();
    }

    @Bean
    public WebExecutorRefreshListener hippo4jWebExecutorListener() {
        return new WebExecutorRefreshListener();
    }

    @Bean
    public DynamicThreadPoolAdapterRegister threadPoolAdapterRegister() {
        return new DynamicThreadPoolAdapterRegister(this.bootstrapCoreProperties);
    }

    @Bean
    public DynamicThreadPoolBannerHandler threadPoolBannerHandler() {
        return new DynamicThreadPoolBannerHandler((BootstrapPropertiesInterface)this.bootstrapCoreProperties);
    }

    @Bean
    public DynamicThreadPoolConfigService dynamicThreadPoolConfigService() {
        return new DynamicThreadPoolConfigService();
    }

    public DynamicThreadPoolCoreAutoConfiguration(BootstrapCoreProperties bootstrapCoreProperties) {
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

