/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.springboot.starter.config;

import cn.hippo4j.core.springboot.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.springboot.starter.refresher.ApolloRefresherHandler;
import cn.hippo4j.core.springboot.starter.refresher.NacosCloudRefresherHandler;
import cn.hippo4j.core.springboot.starter.refresher.NacosRefresherHandler;
import cn.hippo4j.core.springboot.starter.refresher.ZookeeperRefresherHandler;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ConfigHandlerConfiguration {
    private static final String NACOS_CONFIG_MANAGER_KEY = "com.alibaba.cloud.nacos.NacosConfigManager";
    private static final String NACOS_DATA_ID_KEY = "nacos.data-id";
    private static final String APOLLO_NAMESPACE_KEY = "apollo.namespace";
    private static final String ZOOKEEPER_CONNECT_STR_KEY = "zookeeper.zk-connect-str";

    @ConditionalOnClass(value={CuratorFramework.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"zookeeper.zk-connect-str"})
    static class EmbeddedZookeeper {
        EmbeddedZookeeper() {
        }

        @Bean
        public ZookeeperRefresherHandler zookeeperRefresher() {
            return new ZookeeperRefresherHandler();
        }
    }

    @ConditionalOnClass(value={com.ctrip.framework.apollo.ConfigService.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"apollo.namespace"})
    static class EmbeddedApollo {
        EmbeddedApollo() {
        }

        @Bean
        public ApolloRefresherHandler apolloRefresher() {
            return new ApolloRefresherHandler();
        }
    }

    @ConditionalOnClass(value={NacosConfigManager.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"nacos.data-id"})
    static class EmbeddedNacosCloud {
        EmbeddedNacosCloud() {
        }

        @Bean
        public NacosCloudRefresherHandler nacosCloudRefresherHandler() {
            return new NacosCloudRefresherHandler();
        }
    }

    @ConditionalOnClass(value={ConfigService.class})
    @ConditionalOnMissingClass(value={"com.alibaba.cloud.nacos.NacosConfigManager"})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"nacos.data-id"})
    static class EmbeddedNacos {
        public final BootstrapCoreProperties bootstrapCoreProperties;

        @Bean
        public NacosRefresherHandler nacosRefresherHandler() {
            return new NacosRefresherHandler(this.bootstrapCoreProperties);
        }

        public EmbeddedNacos(BootstrapCoreProperties bootstrapCoreProperties) {
            this.bootstrapCoreProperties = bootstrapCoreProperties;
        }
    }
}

