/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.refresher;

import cn.hippo4j.common.api.ThreadPoolDynamicRefresh;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.PoolParameter;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.notify.HippoBaseSendMessageService;
import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.common.notify.ThreadPoolNotifyAlarm;
import cn.hippo4j.common.notify.request.ChangeParameterNotifyRequest;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ResizableCapacityLinkedBlockIngQueue;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.executor.web.WebThreadPoolHandlerChoose;
import cn.hippo4j.core.executor.web.WebThreadPoolService;
import cn.hippo4j.core.proxy.RejectedProxyUtil;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.config.ExecutorProperties;
import cn.hippo4j.core.starter.config.WebThreadPoolProperties;
import cn.hippo4j.core.starter.notify.CoreNotifyConfigBuilder;
import cn.hippo4j.core.starter.parser.ConfigParserHandler;
import cn.hippo4j.core.starter.refresher.BootstrapCorePropertiesBinderAdapt;
import cn.hippo4j.core.starter.support.GlobalCoreThreadPoolManage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCoreThreadPoolDynamicRefresh
implements ThreadPoolDynamicRefresh,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractCoreThreadPoolDynamicRefresh.class);
    private final ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler;
    protected final BootstrapCoreProperties bootstrapCoreProperties;
    protected final ExecutorService dynamicRefreshExecutorService = ThreadPoolBuilder.builder().threadFactory("client.dynamic.refresh").singlePool().build();

    public void dynamicRefresh(String content) {
        Map<Object, Object> configInfo;
        try {
            configInfo = ConfigParserHandler.getInstance().parseConfig(content, this.bootstrapCoreProperties.getConfigFileType());
        }
        catch (IOException e) {
            log.error("dynamic-thread-pool parse config file error, content: {}, fileType: {}", new Object[]{content, this.bootstrapCoreProperties.getConfigFileType(), e});
            return;
        }
        BootstrapCoreProperties bindableCoreProperties = BootstrapCorePropertiesBinderAdapt.bootstrapCorePropertiesBinder(configInfo, this.bootstrapCoreProperties);
        this.refreshWebExecutor(bindableCoreProperties);
        this.refreshPlatforms(bindableCoreProperties);
        this.refreshExecutors(bindableCoreProperties);
    }

    public void registerNotifyAlarmManage() {
        this.bootstrapCoreProperties.getExecutors().forEach(executorProperties -> {
            ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(executorProperties.getNotify().getIsAlarm(), executorProperties.getNotify().getCapacityAlarm(), executorProperties.getNotify().getActiveAlarm());
            threadPoolNotifyAlarm.setInterval(executorProperties.getNotify().getInterval());
            threadPoolNotifyAlarm.setReceives(executorProperties.receives());
            GlobalNotifyAlarmManage.put((String)executorProperties.getThreadPoolId(), (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
        });
    }

    private void refreshWebExecutor(BootstrapCoreProperties bindableCoreProperties) {
        boolean isNullFlag;
        boolean bl = isNullFlag = bindableCoreProperties.getJetty() == null || bindableCoreProperties.getUndertow() == null || bindableCoreProperties.getTomcat() == null;
        if (isNullFlag) {
            return;
        }
        try {
            WebThreadPoolHandlerChoose webThreadPoolHandlerChoose;
            WebThreadPoolService webThreadPoolService;
            PoolParameter beforeParameter;
            PoolParameterInfo nowParameter = this.buildWebPoolParameter(bindableCoreProperties);
            if (!(nowParameter == null || Objects.equals((beforeParameter = (webThreadPoolService = (webThreadPoolHandlerChoose = (WebThreadPoolHandlerChoose)ApplicationContextHolder.getBean(WebThreadPoolHandlerChoose.class)).choose()).getWebThreadPoolParameter()).getCoreSize(), nowParameter.getCoreSize()) && Objects.equals(beforeParameter.getMaxSize(), nowParameter.getMaxSize()) && Objects.equals(beforeParameter.getKeepAliveTime(), nowParameter.getKeepAliveTime()))) {
                webThreadPoolService.updateWebThreadPool(nowParameter);
            }
        }
        catch (Exception ex) {
            log.error("Failed to modify web thread pool.", (Throwable)ex);
        }
    }

    private void refreshPlatforms(BootstrapCoreProperties bindableCoreProperties) {
        List<ExecutorProperties> executors = bindableCoreProperties.getExecutors();
        for (ExecutorProperties executor : executors) {
            String threadPoolId = executor.getThreadPoolId();
            DynamicThreadPoolWrapper wrapper = GlobalThreadPoolManage.getExecutorService((String)threadPoolId);
            if (wrapper.isInitFlag()) continue;
            HippoBaseSendMessageService sendMessageService = (HippoBaseSendMessageService)ApplicationContextHolder.getBean(HippoBaseSendMessageService.class);
            CoreNotifyConfigBuilder configBuilder = (CoreNotifyConfigBuilder)ApplicationContextHolder.getBean(CoreNotifyConfigBuilder.class);
            Map<String, List<NotifyConfigDTO>> notifyConfig = configBuilder.buildSingleNotifyConfig(executor);
            sendMessageService.putPlatform(notifyConfig);
            wrapper.setInitFlag(Boolean.TRUE.booleanValue());
        }
    }

    private void refreshExecutors(BootstrapCoreProperties bindableCoreProperties) {
        List<ExecutorProperties> executors = bindableCoreProperties.getExecutors();
        for (ExecutorProperties properties : executors) {
            String threadPoolId = properties.getThreadPoolId();
            if (!this.checkConsistency(threadPoolId, properties)) continue;
            this.dynamicRefreshPool(threadPoolId, properties);
            ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
            GlobalCoreThreadPoolManage.refresh(threadPoolId, properties);
            log.info("[{}] Changed thread pool. \n    coreSize :: [{}]\n    maxSize :: [{}]\n    queueType :: [{}]\n    capacity :: [{}]\n    keepAliveTime :: [{}]\n    executeTimeOut :: [{}]\n    rejectedType :: [{}]\n    allowCoreThreadTimeOut :: [{}]", new Object[]{threadPoolId.toUpperCase(), String.format("%s => %s", beforeProperties.getCorePoolSize(), properties.getCorePoolSize()), String.format("%s => %s", beforeProperties.getMaximumPoolSize(), properties.getMaximumPoolSize()), String.format("%s => %s", beforeProperties.getBlockingQueue(), properties.getBlockingQueue()), String.format("%s => %s", beforeProperties.getQueueCapacity(), properties.getQueueCapacity()), String.format("%s => %s", beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime()), String.format("%s => %s", beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()), String.format("%s => %s", beforeProperties.getRejectedHandler(), properties.getRejectedHandler()), String.format("%s => %s", beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut())});
            try {
                this.threadPoolNotifyAlarmHandler.sendPoolConfigChange(this.newChangeRequest(beforeProperties, properties));
            }
            catch (Throwable ex) {
                log.error("Failed to send change notice. Message :: {}", (Object)ex.getMessage());
            }
        }
    }

    private ChangeParameterNotifyRequest newChangeRequest(ExecutorProperties beforeProperties, ExecutorProperties properties) {
        ChangeParameterNotifyRequest changeRequest = new ChangeParameterNotifyRequest();
        changeRequest.setBeforeCorePoolSize(beforeProperties.getCorePoolSize());
        changeRequest.setBeforeMaximumPoolSize(beforeProperties.getMaximumPoolSize());
        changeRequest.setBeforeAllowsCoreThreadTimeOut(beforeProperties.getAllowCoreThreadTimeOut());
        changeRequest.setBeforeKeepAliveTime(beforeProperties.getKeepAliveTime());
        changeRequest.setBlockingQueueName(beforeProperties.getBlockingQueue());
        changeRequest.setBeforeQueueCapacity(beforeProperties.getQueueCapacity());
        changeRequest.setBeforeRejectedName(beforeProperties.getRejectedHandler());
        changeRequest.setBeforeExecuteTimeOut(beforeProperties.getExecuteTimeOut());
        changeRequest.setThreadPoolId(beforeProperties.getThreadPoolId());
        changeRequest.setNowCorePoolSize(properties.getCorePoolSize());
        changeRequest.setNowMaximumPoolSize(properties.getMaximumPoolSize());
        changeRequest.setNowAllowsCoreThreadTimeOut(properties.getAllowCoreThreadTimeOut());
        changeRequest.setNowKeepAliveTime(properties.getKeepAliveTime());
        changeRequest.setNowQueueCapacity(properties.getQueueCapacity());
        changeRequest.setNowRejectedName(properties.getRejectedHandler());
        changeRequest.setNowExecuteTimeOut(properties.getExecuteTimeOut());
        return changeRequest;
    }

    private boolean checkConsistency(String threadPoolId, ExecutorProperties properties) {
        ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        boolean result = !Objects.equals(beforeProperties.getCorePoolSize(), properties.getCorePoolSize()) || !Objects.equals(beforeProperties.getMaximumPoolSize(), properties.getMaximumPoolSize()) || !Objects.equals(beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut()) || !Objects.equals(beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()) || !Objects.equals(beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime()) || !Objects.equals(beforeProperties.getRejectedHandler(), properties.getRejectedHandler()) || !Objects.equals(beforeProperties.getQueueCapacity(), properties.getQueueCapacity()) && Objects.equals(QueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.name, executor.getQueue().getClass().getSimpleName());
        return result;
    }

    private void dynamicRefreshPool(String threadPoolId, ExecutorProperties properties) {
        ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        if (!Objects.equals(beforeProperties.getMaximumPoolSize(), properties.getMaximumPoolSize())) {
            executor.setMaximumPoolSize(properties.getMaximumPoolSize());
        }
        if (!Objects.equals(beforeProperties.getCorePoolSize(), properties.getCorePoolSize())) {
            executor.setCorePoolSize(properties.getCorePoolSize());
        }
        if (!Objects.equals(beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut())) {
            executor.allowCoreThreadTimeOut(properties.getAllowCoreThreadTimeOut());
        }
        if (!Objects.equals(beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()) && executor instanceof AbstractDynamicExecutorSupport) {
            ((DynamicThreadPoolExecutor)executor).setExecuteTimeOut(properties.getExecuteTimeOut());
        }
        if (!Objects.equals(beforeProperties.getRejectedHandler(), properties.getRejectedHandler())) {
            RejectedExecutionHandler rejectedExecutionHandler = RejectedTypeEnum.createPolicy((String)properties.getRejectedHandler());
            if (executor instanceof AbstractDynamicExecutorSupport) {
                DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)executor;
                dynamicExecutor.setRedundancyHandler(rejectedExecutionHandler);
                AtomicLong rejectCount = dynamicExecutor.getRejectCount();
                rejectedExecutionHandler = RejectedProxyUtil.createProxy((RejectedExecutionHandler)rejectedExecutionHandler, (String)threadPoolId, (AtomicLong)rejectCount);
            }
            executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        }
        if (!Objects.equals(beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime())) {
            executor.setKeepAliveTime(properties.getKeepAliveTime(), TimeUnit.SECONDS);
        }
        if (!Objects.equals(beforeProperties.getQueueCapacity(), properties.getQueueCapacity()) && Objects.equals(QueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.name, executor.getQueue().getClass().getSimpleName())) {
            if (executor.getQueue() instanceof ResizableCapacityLinkedBlockIngQueue) {
                ResizableCapacityLinkedBlockIngQueue queue = (ResizableCapacityLinkedBlockIngQueue)executor.getQueue();
                queue.setCapacity(properties.getQueueCapacity());
            } else {
                log.warn("The queue length cannot be modified. Queue type mismatch. Current queue type :: {}", (Object)executor.getQueue().getClass().getSimpleName());
            }
        }
    }

    private PoolParameterInfo buildWebPoolParameter(BootstrapCoreProperties bindableCoreProperties) {
        PoolParameterInfo parameterInfo = null;
        WebThreadPoolProperties poolProperties = null;
        if (bindableCoreProperties.getTomcat() != null) {
            poolProperties = bindableCoreProperties.getTomcat();
        } else if (bindableCoreProperties.getUndertow() != null) {
            poolProperties = bindableCoreProperties.getUndertow();
        } else if (bindableCoreProperties.getJetty() != null) {
            poolProperties = bindableCoreProperties.getJetty();
        }
        if (poolProperties != null) {
            parameterInfo = new PoolParameterInfo();
            parameterInfo.setCoreSize(poolProperties.getCorePoolSize());
            parameterInfo.setMaxSize(poolProperties.getMaximumPoolSize());
            parameterInfo.setKeepAliveTime(poolProperties.getKeepAliveTime());
        }
        return parameterInfo;
    }

    public AbstractCoreThreadPoolDynamicRefresh(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        this.threadPoolNotifyAlarmHandler = threadPoolNotifyAlarmHandler;
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

