/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.support;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.notify.ThreadPoolNotifyAlarm;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.executor.DynamicThreadPool;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.CommonDynamicThreadPool;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.config.ExecutorProperties;
import cn.hippo4j.core.starter.support.GlobalCoreThreadPoolManage;
import cn.hippo4j.core.toolkit.inet.DynamicThreadPoolAnnotationUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.task.TaskDecorator;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapCoreProperties bootstrapCoreProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor) {
            try {
                DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
                if (Objects.isNull(dynamicThreadPool) && Objects.isNull(dynamicThreadPool = (DynamicThreadPool)DynamicThreadPoolAnnotationUtil.findAnnotationOnBean((String)beanName, DynamicThreadPool.class))) {
                    return bean;
                }
            }
            catch (Exception ex) {
                log.error("Failed to create dynamic thread pool in annotation mode.", (Throwable)ex);
                return bean;
            }
            DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)bean;
            DynamicThreadPoolWrapper wrap = new DynamicThreadPoolWrapper(dynamicExecutor.getThreadPoolId(), (ThreadPoolExecutor)dynamicExecutor);
            ThreadPoolExecutor remoteExecutor = this.fillPoolAndRegister(wrap);
            return remoteExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper wrap = (DynamicThreadPoolWrapper)bean;
            this.registerAndSubscribe(wrap);
        }
        return bean;
    }

    protected void registerAndSubscribe(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        this.fillPoolAndRegister(dynamicThreadPoolWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        String threadPoolId = dynamicThreadPoolWrap.getTpId();
        ThreadPoolExecutor newDynamicPoolExecutor = dynamicThreadPoolWrap.getExecutor();
        ExecutorProperties executorProperties = null;
        if (null != this.bootstrapCoreProperties.getExecutors()) {
            executorProperties = this.bootstrapCoreProperties.getExecutors().stream().filter(each -> Objects.equals(threadPoolId, each.getThreadPoolId())).findFirst().orElse(null);
            if (executorProperties != null) {
                try {
                    BlockingQueue workQueue = QueueTypeEnum.createBlockingQueue((String)executorProperties.getBlockingQueue(), (Integer)executorProperties.getQueueCapacity());
                    String threadNamePrefix = executorProperties.getThreadNamePrefix();
                    newDynamicPoolExecutor = ThreadPoolBuilder.builder().dynamicPool().workQueue(workQueue).threadFactory(StringUtil.isNotBlank((CharSequence)threadNamePrefix) ? threadNamePrefix : threadPoolId).executeTimeOut(Optional.ofNullable(executorProperties.getExecuteTimeOut()).orElse(0L).longValue()).poolThreadSize(executorProperties.getCorePoolSize().intValue(), executorProperties.getMaximumPoolSize().intValue()).keepAliveTime(executorProperties.getKeepAliveTime().longValue(), TimeUnit.SECONDS).rejected(RejectedTypeEnum.createPolicy((String)executorProperties.getRejectedHandler())).allowCoreThreadTimeOut(executorProperties.getAllowCoreThreadTimeOut().booleanValue()).build();
                }
                catch (Exception ex) {
                    log.error("Failed to initialize thread pool configuration. error :: {}", (Throwable)ex);
                }
                finally {
                    if (Objects.isNull(dynamicThreadPoolWrap.getExecutor())) {
                        dynamicThreadPoolWrap.setExecutor((ThreadPoolExecutor)CommonDynamicThreadPool.getInstance((String)threadPoolId));
                    }
                    dynamicThreadPoolWrap.setInitFlag(Boolean.TRUE.booleanValue());
                }
            }
            if (dynamicThreadPoolWrap.getExecutor() instanceof AbstractDynamicExecutorSupport) {
                ThreadPoolNotifyAlarm notify = executorProperties.getNotify();
                boolean isAlarm = Optional.ofNullable(notify).map(each -> each.getIsAlarm()).orElseGet(() -> this.bootstrapCoreProperties.getAlarm() != null ? this.bootstrapCoreProperties.getAlarm() : true);
                int activeAlarm = Optional.ofNullable(notify).map(each -> each.getActiveAlarm()).orElseGet(() -> this.bootstrapCoreProperties.getActiveAlarm() != null ? this.bootstrapCoreProperties.getActiveAlarm() : 80);
                int capacityAlarm = Optional.ofNullable(notify).map(each -> each.getActiveAlarm()).orElseGet(() -> this.bootstrapCoreProperties.getCapacityAlarm() != null ? this.bootstrapCoreProperties.getCapacityAlarm() : 80);
                int interval = Optional.ofNullable(notify).map(each -> each.getInterval()).orElseGet(() -> this.bootstrapCoreProperties.getAlarmInterval() != null ? this.bootstrapCoreProperties.getAlarmInterval() : 5);
                String receive = Optional.ofNullable(notify).map(each -> each.getReceive()).orElseGet(() -> this.bootstrapCoreProperties.getReceive() != null ? this.bootstrapCoreProperties.getReceive() : null);
                ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(isAlarm), Integer.valueOf(activeAlarm), Integer.valueOf(capacityAlarm));
                threadPoolNotifyAlarm.setInterval(Integer.valueOf(interval));
                threadPoolNotifyAlarm.setReceive(receive);
                GlobalNotifyAlarmManage.put((String)threadPoolId, (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
                TaskDecorator taskDecorator = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).getTaskDecorator();
                ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setTaskDecorator(taskDecorator);
                long awaitTerminationMillis = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).awaitTerminationMillis;
                boolean waitForTasksToCompleteOnShutdown = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).waitForTasksToCompleteOnShutdown;
                ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setSupportParam(awaitTerminationMillis, waitForTasksToCompleteOnShutdown);
            }
            dynamicThreadPoolWrap.setExecutor(newDynamicPoolExecutor);
        }
        GlobalThreadPoolManage.registerPool((String)dynamicThreadPoolWrap.getTpId(), (DynamicThreadPoolWrapper)dynamicThreadPoolWrap);
        GlobalCoreThreadPoolManage.register(threadPoolId, executorProperties == null ? this.buildExecutorProperties(threadPoolId, newDynamicPoolExecutor) : executorProperties);
        return newDynamicPoolExecutor;
    }

    private ExecutorProperties buildExecutorProperties(String threadPoolId, ThreadPoolExecutor executor) {
        ExecutorProperties executorProperties = new ExecutorProperties();
        BlockingQueue<Runnable> queue = executor.getQueue();
        int queueSize = queue.size();
        String queueType = queue.getClass().getSimpleName();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        executorProperties.setCorePoolSize(executor.getCorePoolSize()).setMaximumPoolSize(executor.getMaximumPoolSize()).setAllowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut()).setKeepAliveTime(executor.getKeepAliveTime(TimeUnit.SECONDS)).setBlockingQueue(queueType).setExecuteTimeOut(10000L).setQueueCapacity(queueCapacity).setRejectedHandler(((DynamicThreadPoolExecutor)executor).getRedundancyHandler().getClass().getSimpleName()).setThreadPoolId(threadPoolId);
        return executorProperties;
    }

    public DynamicThreadPoolPostProcessor(BootstrapCoreProperties bootstrapCoreProperties) {
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

