/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.refresher;

import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.refresher.AbstractCoreThreadPoolDynamicRefresh;
import com.google.common.base.Charsets;
import java.util.List;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.WatchedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRefresherHandler
extends AbstractCoreThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRefresherHandler.class);
    private CuratorFramework curatorFramework;

    public ZookeeperRefresherHandler(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        super(threadPoolNotifyAlarmHandler, bootstrapCoreProperties);
    }

    public void afterPropertiesSet() {
        Map<String, String> zkConfigs = this.bootstrapCoreProperties.getZookeeper();
        this.curatorFramework = CuratorFrameworkFactory.newClient((String)zkConfigs.get("zk-connect-str"), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        String nodePath = ZKPaths.makePath((String)ZKPaths.makePath((String)zkConfigs.get("root-node"), (String)zkConfigs.get("config-version")), (String)zkConfigs.get("node"));
        ConnectionStateListener connectionStateListener = (client, newState) -> {
            if (newState == ConnectionState.CONNECTED) {
                this.loadNode(nodePath);
            } else if (newState == ConnectionState.RECONNECTED) {
                this.loadNode(nodePath);
            }
        };
        CuratorListener curatorListener = (client, curatorEvent) -> {
            WatchedEvent watchedEvent = curatorEvent.getWatchedEvent();
            if (null != watchedEvent) {
                switch (watchedEvent.getType()) {
                    case NodeChildrenChanged: 
                    case NodeDataChanged: {
                        this.loadNode(nodePath);
                        break;
                    }
                }
            }
        };
        this.curatorFramework.getConnectionStateListenable().addListener((Object)connectionStateListener);
        this.curatorFramework.getCuratorListenable().addListener((Object)curatorListener);
        this.curatorFramework.start();
    }

    public void loadNode(String nodePath) {
        try {
            GetChildrenBuilder childrenBuilder = this.curatorFramework.getChildren();
            List children = (List)((BackgroundPathable)childrenBuilder.watched()).forPath(nodePath);
            StringBuilder content = new StringBuilder();
            children.forEach(c -> {
                String n = ZKPaths.makePath((String)nodePath, (String)c);
                String nodeName = ZKPaths.getNodeFromPath((String)n);
                GetDataBuilder data = this.curatorFramework.getData();
                String value = "";
                try {
                    value = new String((byte[])((BackgroundPathable)data.watched()).forPath(n), Charsets.UTF_8);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                content.append(nodeName).append("=").append(value).append("\n");
            });
            this.dynamicRefresh(content.toString());
            this.registerNotifyAlarmManage();
        }
        catch (Exception e) {
            log.error("load zk node error, nodePath is {}", (Object)nodePath, (Object)e);
        }
    }
}

