/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.refresher;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.refresher.AbstractCoreThreadPoolDynamicRefresh;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRefresherHandler
extends AbstractCoreThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(NacosRefresherHandler.class);
    private final ConfigService configService = (ConfigService)ApplicationContextHolder.getBean(ConfigService.class);

    public NacosRefresherHandler(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        super(threadPoolNotifyAlarmHandler, bootstrapCoreProperties);
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, String> nacosConfig = this.bootstrapCoreProperties.getNacos();
        this.configService.addListener(nacosConfig.get("data-id"), nacosConfig.get("group"), new Listener(){

            public Executor getExecutor() {
                return NacosRefresherHandler.this.dynamicRefreshExecutorService;
            }

            public void receiveConfigInfo(String configInfo) {
                NacosRefresherHandler.this.dynamicRefresh(configInfo);
            }
        });
    }
}

