/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.refresher;

import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.refresher.AbstractCoreThreadPoolDynamicRefresh;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ApolloRefresherHandler
extends AbstractCoreThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(ApolloRefresherHandler.class);
    private static final String APOLLO_PROPERTY = "${spring.dynamic.thread-pool.apollo.namespace:application}";
    @Value(value="${spring.dynamic.thread-pool.apollo.namespace:application}")
    private String namespace;

    public ApolloRefresherHandler(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        super(threadPoolNotifyAlarmHandler, bootstrapCoreProperties);
    }

    public void afterPropertiesSet() {
        String[] apolloNamespaces = this.namespace.split(",");
        this.namespace = apolloNamespaces[0];
        Config config = ConfigService.getConfig((String)this.namespace);
        ConfigChangeListener configChangeListener = configChangeEvent -> {
            ConfigFile configFile = ConfigService.getConfigFile((String)this.namespace.replaceAll("." + this.bootstrapCoreProperties.getConfigFileType().getValue(), ""), (ConfigFileFormat)ConfigFileFormat.fromString((String)this.bootstrapCoreProperties.getConfigFileType().getValue()));
            String configInfo = configFile.getContent();
            this.dynamicRefresh(configInfo);
        };
        config.addChangeListener(configChangeListener);
        log.info("dynamic-thread-pool refresher, add apollo listener success, namespace: {}", (Object)this.namespace);
    }
}

