/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.notify;

import cn.hippo4j.common.api.NotifyConfigBuilder;
import cn.hippo4j.common.notify.AlarmControlHandler;
import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.config.ExecutorProperties;
import cn.hippo4j.core.starter.config.NotifyPlatformProperties;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CoreNotifyConfigBuilder
implements NotifyConfigBuilder {
    private final AlarmControlHandler alarmControlHandler;
    private final BootstrapCoreProperties bootstrapCoreProperties;

    public Map<String, List<NotifyConfigDTO>> buildNotify() {
        HashMap resultMap = Maps.newHashMap();
        List<ExecutorProperties> executors = this.bootstrapCoreProperties.getExecutors();
        if (null != executors) {
            for (ExecutorProperties executor : executors) {
                resultMap.putAll(this.buildSingleNotifyConfig(executor));
            }
        }
        return resultMap;
    }

    public Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig(ExecutorProperties executor) {
        HashMap resultMap = Maps.newHashMap();
        String threadPoolId = executor.getThreadPoolId();
        String alarmBuildKey = threadPoolId + "+ALARM";
        ArrayList alarmNotifyConfigs = Lists.newArrayList();
        List<NotifyPlatformProperties> notifyPlatforms = this.bootstrapCoreProperties.getNotifyPlatforms();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setTpId(threadPoolId);
            notifyConfig.setType("ALARM");
            notifyConfig.setSecret(platformProperties.getSecret());
            notifyConfig.setSecretKey(this.getToken(platformProperties));
            int interval = Optional.ofNullable(executor.getNotify()).map(each -> each.getInterval()).orElseGet(() -> this.bootstrapCoreProperties.getAlarmInterval() != null ? this.bootstrapCoreProperties.getAlarmInterval() : 5);
            notifyConfig.setInterval(Integer.valueOf(interval));
            notifyConfig.setReceives(this.buildReceive(executor, platformProperties));
            alarmNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(alarmBuildKey, alarmNotifyConfigs);
        String changeBuildKey = threadPoolId + "+CONFIG";
        ArrayList changeNotifyConfigs = Lists.newArrayList();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setTpId(threadPoolId);
            notifyConfig.setType("CONFIG");
            notifyConfig.setSecretKey(this.getToken(platformProperties));
            notifyConfig.setSecret(platformProperties.getSecret());
            notifyConfig.setReceives(this.buildReceive(executor, platformProperties));
            changeNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(changeBuildKey, changeNotifyConfigs);
        resultMap.forEach((key, val) -> val.stream().filter(each -> StrUtil.equals((CharSequence)"ALARM", (CharSequence)each.getType())).forEach(each -> this.alarmControlHandler.initCacheAndLock(each.getTpId(), each.getPlatform(), each.getInterval())));
        return resultMap;
    }

    private String buildReceive(ExecutorProperties executor, NotifyPlatformProperties platformProperties) {
        String receive;
        if (executor.getNotify() != null) {
            receive = executor.getNotify().getReceive();
            if (StrUtil.isBlank((CharSequence)receive) && StrUtil.isBlank((CharSequence)(receive = this.bootstrapCoreProperties.getReceive()))) {
                Map<String, String> receives = executor.receives();
                receive = receives.get(platformProperties.getPlatform());
            }
        } else {
            receive = this.bootstrapCoreProperties.getReceive();
            if (StrUtil.isBlank((CharSequence)receive)) {
                Map<String, String> receives = executor.receives();
                receive = receives.get(platformProperties.getPlatform());
            }
        }
        return receive;
    }

    private String getToken(NotifyPlatformProperties platformProperties) {
        return StringUtil.isNotBlank((CharSequence)platformProperties.getToken()) ? platformProperties.getToken() : platformProperties.getSecretKey();
    }

    public CoreNotifyConfigBuilder(AlarmControlHandler alarmControlHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        this.alarmControlHandler = alarmControlHandler;
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

