/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.monitor;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.executor.support.ThreadFactoryBuilder;
import cn.hippo4j.core.spi.DynamicThreadPoolServiceLoader;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.monitor.DynamicThreadPoolMonitor;
import cn.hippo4j.core.starter.monitor.ThreadPoolMonitor;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class DynamicThreadPoolMonitorExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolMonitorExecutor.class);
    private final BootstrapCoreProperties properties;
    private ScheduledThreadPoolExecutor collectExecutor;
    private List<ThreadPoolMonitor> threadPoolMonitors;

    public void run(ApplicationArguments args) throws Exception {
        String collectType = this.properties.getCollectType();
        if (!this.properties.getCollect().booleanValue() || StringUtil.isBlank((CharSequence)collectType)) {
            return;
        }
        log.info("Start monitoring the running status of dynamic thread pool.");
        this.threadPoolMonitors = Lists.newArrayList();
        String collectTaskName = "client.scheduled.collect.data";
        this.collectExecutor = new ScheduledThreadPoolExecutor((int)new Integer(1), ThreadFactoryBuilder.builder().daemon(true).prefix(collectTaskName).build());
        List<String> collectTypes = Arrays.asList(collectType.split(","));
        ApplicationContextHolder.getBeansOfType(ThreadPoolMonitor.class).forEach((key, val) -> {
            if (collectTypes.contains(val.getType())) {
                this.threadPoolMonitors.add((ThreadPoolMonitor)val);
            }
        });
        Collection dynamicThreadPoolMonitors = DynamicThreadPoolServiceLoader.getSingletonServiceInstances(DynamicThreadPoolMonitor.class);
        dynamicThreadPoolMonitors.stream().filter(each -> collectTypes.contains(each.getType())).forEach(each -> this.threadPoolMonitors.add((ThreadPoolMonitor)each));
        this.collectExecutor.scheduleWithFixedDelay(() -> this.scheduleRunnable(), this.properties.getInitialDelay(), this.properties.getCollectInterval(), TimeUnit.MILLISECONDS);
    }

    private void scheduleRunnable() {
        for (ThreadPoolMonitor each : this.threadPoolMonitors) {
            try {
                each.collect();
            }
            catch (Exception ex) {
                log.error("Error monitoring the running status of dynamic thread pool. Type :: {}", (Object)each.getType(), (Object)ex);
            }
        }
    }

    public DynamicThreadPoolMonitorExecutor(BootstrapCoreProperties properties) {
        this.properties = properties;
    }
}

