/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.refresher;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.refresher.AbstractCoreThreadPoolDynamicRefresh;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosCloudRefresherHandler
extends AbstractCoreThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(NacosCloudRefresherHandler.class);
    private final NacosConfigManager nacosConfigManager = (NacosConfigManager)ApplicationContextHolder.getBean(NacosConfigManager.class);

    public NacosCloudRefresherHandler(ThreadPoolNotifyAlarmHandler threadPoolNotifyAlarmHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        super(threadPoolNotifyAlarmHandler, bootstrapCoreProperties);
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, String> nacosConfig = this.bootstrapCoreProperties.getNacos();
        this.nacosConfigManager.getConfigService().addListener(nacosConfig.get("data-id"), nacosConfig.get("group"), new Listener(){

            public Executor getExecutor() {
                return NacosCloudRefresherHandler.this.dynamicRefreshExecutorService;
            }

            public void receiveConfigInfo(String configInfo) {
                NacosCloudRefresherHandler.this.dynamicRefresh(configInfo);
            }
        });
    }
}

