/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.starter.notify;

import cn.hippo4j.common.api.NotifyConfigBuilder;
import cn.hippo4j.common.notify.AlarmControlHandler;
import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.core.starter.config.BootstrapCoreProperties;
import cn.hippo4j.core.starter.config.ExecutorProperties;
import cn.hippo4j.core.starter.config.NotifyPlatformProperties;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoreNotifyConfigBuilder
implements NotifyConfigBuilder {
    private final AlarmControlHandler alarmControlHandler;
    private final BootstrapCoreProperties bootstrapCoreProperties;

    public Map<String, List<NotifyConfigDTO>> buildNotify() {
        HashMap resultMap = Maps.newHashMap();
        List<ExecutorProperties> executors = this.bootstrapCoreProperties.getExecutors();
        for (ExecutorProperties executor : executors) {
            resultMap.putAll(this.buildSingleNotifyConfig(executor));
        }
        return resultMap;
    }

    public Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig(ExecutorProperties executor) {
        HashMap resultMap = Maps.newHashMap();
        String threadPoolId = executor.getThreadPoolId();
        String alarmBuildKey = threadPoolId + "+ALARM";
        ArrayList alarmNotifyConfigs = Lists.newArrayList();
        List<NotifyPlatformProperties> notifyPlatforms = this.bootstrapCoreProperties.getNotifyPlatforms();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setThreadPoolId(threadPoolId);
            notifyConfig.setType("ALARM");
            notifyConfig.setSecretKey(platformProperties.getSecretKey());
            notifyConfig.setInterval(executor.getNotify().getInterval());
            Map receives = executor.getNotify().getReceives();
            String receive = (String)receives.get(platformProperties.getPlatform());
            if (StrUtil.isBlank((CharSequence)receive)) {
                receive = platformProperties.getReceives();
            }
            notifyConfig.setReceives(receive);
            alarmNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(alarmBuildKey, alarmNotifyConfigs);
        String changeBuildKey = threadPoolId + "+CONFIG";
        ArrayList changeNotifyConfigs = Lists.newArrayList();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setThreadPoolId(threadPoolId);
            notifyConfig.setType("CONFIG");
            notifyConfig.setSecretKey(platformProperties.getSecretKey());
            Map receives = executor.getNotify().getReceives();
            String receive = (String)receives.get(platformProperties.getPlatform());
            if (StrUtil.isBlank((CharSequence)receive)) {
                receive = platformProperties.getReceives();
            }
            notifyConfig.setReceives(receive);
            changeNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(changeBuildKey, changeNotifyConfigs);
        resultMap.forEach((key, val) -> val.stream().filter(each -> StrUtil.equals((CharSequence)"ALARM", (CharSequence)each.getType())).forEach(each -> this.alarmControlHandler.initCacheAndLock(each.getThreadPoolId(), each.getPlatform(), each.getInterval())));
        return resultMap;
    }

    public CoreNotifyConfigBuilder(AlarmControlHandler alarmControlHandler, BootstrapCoreProperties bootstrapCoreProperties) {
        this.alarmControlHandler = alarmControlHandler;
        this.bootstrapCoreProperties = bootstrapCoreProperties;
    }
}

