/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web;

import cn.hippo4j.adapter.web.AbstractWebThreadPoolService;
import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.ReflectUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.server.WebServer;

public class JettyWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JettyWebThreadPoolHandler.class);

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        JettyWebServer jettyWebServer = (JettyWebServer)webServer;
        return jettyWebServer.getServer().getThreadPool();
    }

    @Override
    public ThreadPoolBaseInfo simpleInfo() {
        ThreadPoolBaseInfo poolBaseInfo = new ThreadPoolBaseInfo();
        QueuedThreadPool queuedThreadPool = (QueuedThreadPool)this.executor;
        poolBaseInfo.setCoreSize(Integer.valueOf(queuedThreadPool.getMinThreads()));
        poolBaseInfo.setMaximumSize(Integer.valueOf(queuedThreadPool.getMaxThreads()));
        BlockingQueue jobs = (BlockingQueue)ReflectUtil.getFieldValue((Object)queuedThreadPool, (String)"_jobs");
        int queueCapacity = jobs.remainingCapacity() + jobs.size();
        poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        poolBaseInfo.setQueueType(jobs.getClass().getSimpleName());
        poolBaseInfo.setKeepAliveTime(Long.valueOf(queuedThreadPool.getIdleTimeout()));
        poolBaseInfo.setRejectedName("RejectedExecutionException");
        return poolBaseInfo;
    }

    @Override
    public ThreadPoolParameter getWebThreadPoolParameter() {
        ThreadPoolParameterInfo parameterInfo = null;
        try {
            parameterInfo = new ThreadPoolParameterInfo();
            QueuedThreadPool jettyExecutor = (QueuedThreadPool)this.executor;
            int minThreads = jettyExecutor.getMinThreads();
            int maxThreads = jettyExecutor.getMaxThreads();
            parameterInfo.setCoreSize(Integer.valueOf(minThreads));
            parameterInfo.setMaxSize(Integer.valueOf(maxThreads));
        }
        catch (Exception ex) {
            log.error("Failed to get the jetty thread pool parameter.", (Throwable)ex);
        }
        return parameterInfo;
    }

    @Override
    public ThreadPoolRunStateInfo getWebRunStateInfo() {
        return null;
    }

    @Override
    public void updateWebThreadPool(ThreadPoolParameterInfo threadPoolParameterInfo) {
        try {
            QueuedThreadPool jettyExecutor = (QueuedThreadPool)this.executor;
            int minThreads = jettyExecutor.getMinThreads();
            int maxThreads = jettyExecutor.getMaxThreads();
            Integer coreSize = threadPoolParameterInfo.corePoolSizeAdapt();
            Integer maxSize = threadPoolParameterInfo.maximumPoolSizeAdapt();
            jettyExecutor.setMinThreads(coreSize.intValue());
            jettyExecutor.setMaxThreads(maxSize.intValue());
            log.info("[Jetty] Changed web thread pool. corePoolSize: {}, maximumPoolSize: {}", (Object)String.format("%s => %s", minThreads, jettyExecutor.getMinThreads()), (Object)String.format("%s => %s", maxThreads, jettyExecutor.getMaxThreads()));
        }
        catch (Exception ex) {
            log.error("Failed to modify the jetty thread pool parameter.", (Throwable)ex);
        }
    }
}

