/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web;

import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.ByteConvertUtil;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebThreadPoolRunStateHandler
extends AbstractThreadPoolRuntime {
    private static final Logger log = LoggerFactory.getLogger(WebThreadPoolRunStateHandler.class);

    public ThreadPoolRunStateInfo supplement(ThreadPoolRunStateInfo poolRunStateInfo) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        long used = heapMemoryUsage.getUsed();
        long max = heapMemoryUsage.getMax();
        String memoryProportion = "\u5df2\u5206\u914d: " + ByteConvertUtil.getPrintSize((long)used) + " / \u6700\u5927\u53ef\u7528: " + ByteConvertUtil.getPrintSize((long)max);
        poolRunStateInfo.setCurrentLoad(poolRunStateInfo.getCurrentLoad() + "%");
        poolRunStateInfo.setPeakLoad(poolRunStateInfo.getPeakLoad() + "%");
        poolRunStateInfo.setMemoryProportion(memoryProportion);
        poolRunStateInfo.setFreeMemory(ByteConvertUtil.getPrintSize((long)Math.subtractExact(max, used)));
        return poolRunStateInfo;
    }
}

