/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web;

import cn.hippo4j.adapter.web.WebThreadPoolHandlerChoose;
import cn.hippo4j.adapter.web.WebThreadPoolService;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.WebIpAndPortInfo;
import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.boot.web.server.WebServer;

public class WebIpAndPortHolder {
    private static boolean SUPPORT_VERSION = false;
    protected static AtomicReference<WebIpAndPortInfo> WEB_IP_AND_PORT;
    public static final String ALL = "*";
    protected static final String SEPARATOR = ",";

    protected static void initIpAndPort() {
        if (!SUPPORT_VERSION) {
            return;
        }
        WEB_IP_AND_PORT.compareAndSet(null, WebIpAndPortHolder.getWebIpAndPortInfo());
    }

    private static WebIpAndPortInfo getWebIpAndPortInfo() {
        InetUtils inetUtils = (InetUtils)ApplicationContextHolder.getBean(InetUtils.class);
        InetUtils.HostInfo loopBackHostInfo = inetUtils.findFirstNonLoopBackHostInfo();
        Assert.notNull((Object)loopBackHostInfo, (String)"Unable to get the application IP address");
        String ip = loopBackHostInfo.getIpAddress();
        WebThreadPoolHandlerChoose webThreadPoolHandlerChoose = (WebThreadPoolHandlerChoose)ApplicationContextHolder.getBean(WebThreadPoolHandlerChoose.class);
        WebThreadPoolService webThreadPoolService = webThreadPoolHandlerChoose.choose();
        WebServer webServer = webThreadPoolService.getWebServer();
        String port = String.valueOf(webServer.getPort());
        return new WebIpAndPortInfo(ip, port);
    }

    public static WebIpAndPortInfo getWebIpAndPort() {
        if (WEB_IP_AND_PORT.get() == null) {
            WebIpAndPortHolder.initIpAndPort();
        }
        return WEB_IP_AND_PORT.get();
    }

    public static boolean check(String nodes) {
        WebIpAndPortInfo webIpAndPort = WebIpAndPortHolder.getWebIpAndPort();
        if (StringUtil.isEmpty((CharSequence)nodes) || ALL.equals(nodes) || webIpAndPort == null) {
            return true;
        }
        String[] splitNodes = nodes.split(SEPARATOR);
        return Arrays.stream(splitNodes).distinct().map(WebIpAndPortInfo::build).filter(Objects::nonNull).anyMatch(each -> each.check(webIpAndPort.getIpSegment(), webIpAndPort.getPort()));
    }

    private WebIpAndPortHolder() {
    }

    static {
        try {
            Class.forName("org.springframework.boot.web.server.WebServer");
            SUPPORT_VERSION = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        WEB_IP_AND_PORT = new AtomicReference();
    }
}

