/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web;

import cn.hippo4j.adapter.web.AbstractWebThreadPoolService;
import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.CalculateUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import io.undertow.Undertow;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.util.ReflectionUtils;
import org.xnio.Options;
import org.xnio.XnioWorker;

public class UndertowWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(UndertowWebThreadPoolHandler.class);
    private static final String UNDERTOW_NAME = "undertow";

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        UndertowServletWebServer undertowServletWebServer = (UndertowServletWebServer)webServer;
        Field undertowField = ReflectionUtils.findField(UndertowServletWebServer.class, (String)UNDERTOW_NAME);
        ReflectionUtils.makeAccessible((Field)undertowField);
        Undertow undertow = (Undertow)ReflectionUtils.getField((Field)undertowField, (Object)undertowServletWebServer);
        return Objects.isNull(undertow) ? null : undertow.getWorker();
    }

    @Override
    public ThreadPoolBaseInfo simpleInfo() {
        ThreadPoolBaseInfo poolBaseInfo = new ThreadPoolBaseInfo();
        XnioWorker xnioWorker = (XnioWorker)this.executor;
        try {
            int coreSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_CORE_THREADS);
            int maximumPoolSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_MAX_THREADS);
            int keepAliveTime = (Integer)xnioWorker.getOption(Options.WORKER_TASK_KEEPALIVE);
            poolBaseInfo.setCoreSize(Integer.valueOf(coreSize));
            poolBaseInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
            poolBaseInfo.setKeepAliveTime(Long.valueOf(keepAliveTime));
            poolBaseInfo.setRejectedName("-");
            poolBaseInfo.setQueueType("-");
        }
        catch (Exception ex) {
            log.error("The undertow container failed to get thread pool parameters.", (Throwable)ex);
        }
        return poolBaseInfo;
    }

    @Override
    public ThreadPoolParameter getWebThreadPoolParameter() {
        ThreadPoolParameterInfo parameterInfo = null;
        try {
            parameterInfo = new ThreadPoolParameterInfo();
            XnioWorker xnioWorker = (XnioWorker)this.executor;
            int minThreads = (Integer)xnioWorker.getOption(Options.WORKER_TASK_CORE_THREADS);
            int maxThreads = (Integer)xnioWorker.getOption(Options.WORKER_TASK_MAX_THREADS);
            int keepAliveTime = (Integer)xnioWorker.getOption(Options.WORKER_TASK_KEEPALIVE);
            parameterInfo.setCoreSize(Integer.valueOf(minThreads));
            parameterInfo.setMaxSize(Integer.valueOf(maxThreads));
            parameterInfo.setKeepAliveTime(Integer.valueOf(keepAliveTime));
        }
        catch (Exception ex) {
            log.error("Failed to get the undertow thread pool parameter.", (Throwable)ex);
        }
        return parameterInfo;
    }

    @Override
    public ThreadPoolRunStateInfo getWebRunStateInfo() {
        ThreadPoolRunStateInfo stateInfo = new ThreadPoolRunStateInfo();
        XnioWorker xnioWorker = (XnioWorker)this.executor;
        Field field = ReflectionUtils.findField(XnioWorker.class, (String)"taskPool");
        ReflectionUtils.makeAccessible((Field)field);
        Object fieldObject = ReflectionUtils.getField((Field)field, (Object)xnioWorker);
        Method getCorePoolSize = ReflectionUtils.findMethod(fieldObject.getClass(), (String)"getCorePoolSize");
        ReflectionUtils.makeAccessible((Method)getCorePoolSize);
        int corePoolSize = (Integer)ReflectionUtils.invokeMethod((Method)getCorePoolSize, (Object)fieldObject);
        Method getMaximumPoolSize = ReflectionUtils.findMethod(fieldObject.getClass(), (String)"getMaximumPoolSize");
        ReflectionUtils.makeAccessible((Method)getMaximumPoolSize);
        int maximumPoolSize = (Integer)ReflectionUtils.invokeMethod((Method)getMaximumPoolSize, (Object)fieldObject);
        Method getPoolSize = ReflectionUtils.findMethod(fieldObject.getClass(), (String)"getPoolSize");
        ReflectionUtils.makeAccessible((Method)getPoolSize);
        int poolSize = (Integer)ReflectionUtils.invokeMethod((Method)getPoolSize, (Object)fieldObject);
        Method getActiveCount = ReflectionUtils.findMethod(fieldObject.getClass(), (String)"getActiveCount");
        ReflectionUtils.makeAccessible((Method)getActiveCount);
        int activeCount = (Integer)ReflectionUtils.invokeMethod((Method)getActiveCount, (Object)fieldObject);
        activeCount = Math.max(activeCount, 0);
        String currentLoad = CalculateUtil.divide((int)activeCount, (int)maximumPoolSize) + "";
        String peakLoad = CalculateUtil.divide((int)activeCount, (int)maximumPoolSize) + "";
        stateInfo.setCoreSize(Integer.valueOf(corePoolSize));
        stateInfo.setPoolSize(Integer.valueOf(poolSize));
        stateInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        stateInfo.setActiveSize(Integer.valueOf(activeCount));
        stateInfo.setCurrentLoad(currentLoad);
        stateInfo.setPeakLoad(peakLoad);
        long rejectCount = fieldObject instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)fieldObject).getRejectCountNum() : -1L;
        stateInfo.setRejectCount(Long.valueOf(rejectCount));
        stateInfo.setClientLastRefreshTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        stateInfo.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return stateInfo;
    }

    @Override
    public void updateWebThreadPool(ThreadPoolParameterInfo threadPoolParameterInfo) {
        try {
            XnioWorker xnioWorker = (XnioWorker)this.executor;
            Integer coreSize = threadPoolParameterInfo.corePoolSizeAdapt();
            Integer maxSize = threadPoolParameterInfo.maximumPoolSizeAdapt();
            Integer keepAliveTime = threadPoolParameterInfo.getKeepAliveTime();
            int originalCoreSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_CORE_THREADS);
            int originalMaximumPoolSize = (Integer)xnioWorker.getOption(Options.WORKER_TASK_MAX_THREADS);
            int originalKeepAliveTime = (Integer)xnioWorker.getOption(Options.WORKER_TASK_KEEPALIVE);
            xnioWorker.setOption(Options.WORKER_TASK_CORE_THREADS, (Object)coreSize);
            xnioWorker.setOption(Options.WORKER_TASK_MAX_THREADS, (Object)maxSize);
            xnioWorker.setOption(Options.WORKER_TASK_KEEPALIVE, (Object)keepAliveTime);
            log.info("[Undertow] Changed web thread pool. corePoolSize: {}, maximumPoolSize: {}, keepAliveTime: {}", new Object[]{String.format("%s => %s", originalCoreSize, coreSize), String.format("%s => %s", originalMaximumPoolSize, maxSize), String.format("%s => %s", originalKeepAliveTime, keepAliveTime)});
        }
        catch (Exception ex) {
            log.error("Failed to modify the undertow thread pool parameter.", (Throwable)ex);
        }
    }
}

