/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.springcloud.stream.rocketmq;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.ReflectUtil;
import com.alibaba.cloud.stream.binder.rocketmq.consuming.RocketMQListenerBindingContainer;
import com.alibaba.cloud.stream.binder.rocketmq.integration.RocketMQInboundChannelAdapter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageConcurrentlyService;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.context.ApplicationListener;

public class SpringCloudStreamRocketMQThreadPoolAdapter
implements ThreadPoolAdapter,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SpringCloudStreamRocketMQThreadPoolAdapter.class);
    private final Map<String, ThreadPoolExecutor> ROCKET_MQ_SPRING_CLOUD_STREAM_CONSUME_EXECUTOR = Maps.newHashMap();

    public String mark() {
        return "RocketMQSpringCloudStream";
    }

    public ThreadPoolAdapterState getThreadPoolState(String identify) {
        ThreadPoolAdapterState result = new ThreadPoolAdapterState();
        ThreadPoolExecutor rocketMQConsumeExecutor = this.ROCKET_MQ_SPRING_CLOUD_STREAM_CONSUME_EXECUTOR.get(identify);
        if (rocketMQConsumeExecutor != null) {
            result.setThreadPoolKey(identify);
            result.setCoreSize(Integer.valueOf(rocketMQConsumeExecutor.getCorePoolSize()));
            result.setMaximumSize(Integer.valueOf(rocketMQConsumeExecutor.getMaximumPoolSize()));
            return result;
        }
        log.warn("[{}] RocketMQ consuming thread pool not found.", (Object)identify);
        return result;
    }

    public List<ThreadPoolAdapterState> getThreadPoolStates() {
        ArrayList adapterStateList = Lists.newArrayList();
        this.ROCKET_MQ_SPRING_CLOUD_STREAM_CONSUME_EXECUTOR.forEach((key, val) -> adapterStateList.add(this.getThreadPoolState((String)key)));
        return adapterStateList;
    }

    public boolean updateThreadPool(ThreadPoolAdapterParameter threadPoolAdapterParameter) {
        String threadPoolKey = threadPoolAdapterParameter.getThreadPoolKey();
        ThreadPoolExecutor rocketMQConsumeExecutor = this.ROCKET_MQ_SPRING_CLOUD_STREAM_CONSUME_EXECUTOR.get(threadPoolKey);
        if (rocketMQConsumeExecutor != null) {
            int originalCoreSize = rocketMQConsumeExecutor.getCorePoolSize();
            int originalMaximumPoolSize = rocketMQConsumeExecutor.getMaximumPoolSize();
            rocketMQConsumeExecutor.setCorePoolSize(threadPoolAdapterParameter.getCorePoolSize());
            rocketMQConsumeExecutor.setMaximumPoolSize(threadPoolAdapterParameter.getMaximumPoolSize());
            log.info("[{}] RocketMQ consumption thread pool parameter change. coreSize: {}, maximumSize: {}", new Object[]{threadPoolKey, String.format("%s => %s", originalCoreSize, rocketMQConsumeExecutor.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, rocketMQConsumeExecutor.getMaximumPoolSize())});
            return true;
        }
        log.warn("[{}] RocketMQ consuming thread pool not found.", (Object)threadPoolKey);
        return false;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        InputBindingLifecycle bindingLifecycle = (InputBindingLifecycle)ApplicationContextHolder.getBean(InputBindingLifecycle.class);
        Collection inputBindings = Optional.ofNullable(ReflectUtil.getFieldValue((Object)bindingLifecycle, (String)"inputBindings")).map(each -> (Collection)each).orElse(null);
        if (CollectionUtil.isEmpty((Collection)inputBindings)) {
            log.info("InputBindings record not found.");
        }
        try {
            for (Binding each2 : inputBindings) {
                String bindingName = each2.getBindingName();
                DefaultBinding defaultBinding = (DefaultBinding)each2;
                RocketMQInboundChannelAdapter lifecycle = (RocketMQInboundChannelAdapter)ReflectUtil.getFieldValue((Object)defaultBinding, (String)"lifecycle");
                RocketMQListenerBindingContainer rocketMQListenerContainer = (RocketMQListenerBindingContainer)ReflectUtil.getFieldValue((Object)lifecycle, (String)"rocketMQListenerContainer");
                DefaultMQPushConsumer consumer = rocketMQListenerContainer.getConsumer();
                DefaultMQPushConsumerImpl defaultMQPushConsumerImpl = consumer.getDefaultMQPushConsumerImpl();
                ConsumeMessageConcurrentlyService consumeMessageService = (ConsumeMessageConcurrentlyService)defaultMQPushConsumerImpl.getConsumeMessageService();
                ThreadPoolExecutor consumeExecutor = (ThreadPoolExecutor)ReflectUtil.getFieldValue((Object)consumeMessageService, (String)"consumeExecutor");
                this.ROCKET_MQ_SPRING_CLOUD_STREAM_CONSUME_EXECUTOR.put(bindingName, consumeExecutor);
            }
        }
        catch (Exception ex) {
            log.error("Failed to get input-bindings thread pool.", (Throwable)ex);
        }
    }
}

