/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.rocketmq;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.ReflectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class RocketMQThreadPoolAdapter
implements ThreadPoolAdapter,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(RocketMQThreadPoolAdapter.class);
    private final Map<String, ThreadPoolExecutor> ROCKET_MQ_CONSUME_EXECUTOR = new HashMap<String, ThreadPoolExecutor>();

    public String mark() {
        return "RocketMQ";
    }

    public ThreadPoolAdapterState getThreadPoolState(String identify) {
        ThreadPoolAdapterState result = new ThreadPoolAdapterState();
        ThreadPoolExecutor rocketMQConsumeExecutor = this.ROCKET_MQ_CONSUME_EXECUTOR.get(identify);
        if (rocketMQConsumeExecutor != null) {
            result.setThreadPoolKey(identify);
            result.setCoreSize(Integer.valueOf(rocketMQConsumeExecutor.getCorePoolSize()));
            result.setMaximumSize(Integer.valueOf(rocketMQConsumeExecutor.getMaximumPoolSize()));
            return result;
        }
        log.warn("[{}] RocketMQ consuming thread pool not found.", (Object)identify);
        return result;
    }

    public List<ThreadPoolAdapterState> getThreadPoolStates() {
        ArrayList<ThreadPoolAdapterState> adapterStateList = new ArrayList<ThreadPoolAdapterState>();
        this.ROCKET_MQ_CONSUME_EXECUTOR.forEach((key, val) -> adapterStateList.add(this.getThreadPoolState((String)key)));
        return adapterStateList;
    }

    public boolean updateThreadPool(ThreadPoolAdapterParameter threadPoolAdapterParameter) {
        String threadPoolKey = threadPoolAdapterParameter.getThreadPoolKey();
        ThreadPoolExecutor rocketMQConsumeExecutor = this.ROCKET_MQ_CONSUME_EXECUTOR.get(threadPoolKey);
        if (rocketMQConsumeExecutor != null) {
            int originalCoreSize = rocketMQConsumeExecutor.getCorePoolSize();
            int originalMaximumPoolSize = rocketMQConsumeExecutor.getMaximumPoolSize();
            rocketMQConsumeExecutor.setCorePoolSize(threadPoolAdapterParameter.getCorePoolSize());
            rocketMQConsumeExecutor.setMaximumPoolSize(threadPoolAdapterParameter.getMaximumPoolSize());
            log.info("[{}] RocketMQ consumption thread pool parameter change. coreSize: {}, maximumSize: {}", new Object[]{threadPoolKey, String.format("%s => %s", originalCoreSize, rocketMQConsumeExecutor.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, rocketMQConsumeExecutor.getMaximumPoolSize())});
            return true;
        }
        log.warn("[{}] RocketMQ consuming thread pool not found.", (Object)threadPoolKey);
        return false;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        Map containerMap = ApplicationContextHolder.getBeansOfType(DefaultRocketMQListenerContainer.class);
        try {
            for (DefaultRocketMQListenerContainer container : containerMap.values()) {
                DefaultMQPushConsumer defaultMQPushConsumer = container.getConsumer();
                if (defaultMQPushConsumer == null) continue;
                ConsumeMessageService consumeMessageService = defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getConsumeMessageService();
                ThreadPoolExecutor consumeExecutor = (ThreadPoolExecutor)ReflectUtil.getFieldValue((Object)consumeMessageService, (String)"consumeExecutor");
                this.ROCKET_MQ_CONSUME_EXECUTOR.put(container.getConsumerGroup(), consumeExecutor);
            }
        }
        catch (Exception ex) {
            log.error("Failed to get RocketMQ thread pool.", (Throwable)ex);
        }
    }
}

