/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.rabbitmq;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import cn.hippo4j.common.toolkit.ReflectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class RabbitMQThreadPoolAdapter
implements ThreadPoolAdapter,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQThreadPoolAdapter.class);
    private static final String RABBITMQ = "RabbitMQ";
    private static final String FiledName = "executorService";
    private final Map<String, AbstractConnectionFactory> abstractConnectionFactoryMap;
    private final Map<String, ThreadPoolExecutor> RABBITMQ_THREAD_POOL_TASK_EXECUTOR = new HashMap<String, ThreadPoolExecutor>();

    public String mark() {
        return RABBITMQ;
    }

    public ThreadPoolAdapterState getThreadPoolState(String identify) {
        ThreadPoolAdapterState threadPoolAdapterState = new ThreadPoolAdapterState();
        ThreadPoolExecutor threadPoolTaskExecutor = this.RABBITMQ_THREAD_POOL_TASK_EXECUTOR.get(identify);
        threadPoolAdapterState.setThreadPoolKey(identify);
        if (Objects.nonNull(threadPoolTaskExecutor)) {
            threadPoolAdapterState.setCoreSize(Integer.valueOf(threadPoolTaskExecutor.getCorePoolSize()));
            threadPoolAdapterState.setMaximumSize(Integer.valueOf(threadPoolTaskExecutor.getMaximumPoolSize()));
        }
        return threadPoolAdapterState;
    }

    public List<ThreadPoolAdapterState> getThreadPoolStates() {
        ArrayList<ThreadPoolAdapterState> adapterStateList = new ArrayList<ThreadPoolAdapterState>();
        this.RABBITMQ_THREAD_POOL_TASK_EXECUTOR.forEach((key, val) -> adapterStateList.add(this.getThreadPoolState((String)key)));
        return adapterStateList;
    }

    public boolean updateThreadPool(ThreadPoolAdapterParameter threadPoolAdapterParameter) {
        String threadPoolKey = threadPoolAdapterParameter.getThreadPoolKey();
        ThreadPoolExecutor threadPoolTaskExecutor = this.RABBITMQ_THREAD_POOL_TASK_EXECUTOR.get(threadPoolKey);
        if (Objects.nonNull(threadPoolTaskExecutor)) {
            int originalCoreSize = threadPoolTaskExecutor.getCorePoolSize();
            int originalMaximumPoolSize = threadPoolTaskExecutor.getMaximumPoolSize();
            threadPoolTaskExecutor.setMaximumPoolSize(threadPoolAdapterParameter.getMaximumPoolSize());
            threadPoolTaskExecutor.setCorePoolSize(threadPoolAdapterParameter.getCorePoolSize());
            log.info("[{}] Rabbitmq consumption thread pool parameter change. coreSize: {}, maximumSize: {}", new Object[]{threadPoolKey, String.format("%s => %s", originalCoreSize, threadPoolAdapterParameter.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, threadPoolAdapterParameter.getMaximumPoolSize())});
            return true;
        }
        log.warn("[{}] Rabbitmq consuming thread pool not found.", (Object)threadPoolKey);
        return false;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.abstractConnectionFactoryMap.forEach((beanName, abstractConnectionFactor) -> {
            ExecutorService executor = (ExecutorService)ReflectUtil.getFieldValue((Object)abstractConnectionFactor, (String)FiledName);
            if (Objects.nonNull(executor)) {
                if (executor instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolTaskExecutor = (ThreadPoolExecutor)executor;
                    this.RABBITMQ_THREAD_POOL_TASK_EXECUTOR.put((String)beanName, threadPoolTaskExecutor);
                    log.info("Rabbitmq executor name {}", beanName);
                } else {
                    log.warn("Custom thread pools only support ThreadPoolExecutor");
                }
            }
        });
    }

    public RabbitMQThreadPoolAdapter(Map<String, AbstractConnectionFactory> abstractConnectionFactoryMap) {
        this.abstractConnectionFactoryMap = abstractConnectionFactoryMap;
    }
}

