/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.dubbo;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import cn.hippo4j.common.toolkit.ReflectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class DubboThreadPoolAdapter
implements ThreadPoolAdapter,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DubboThreadPoolAdapter.class);
    private final Map<String, ThreadPoolExecutor> DUBBO_PROTOCOL_EXECUTOR = new HashMap<String, ThreadPoolExecutor>();

    public String mark() {
        return "Dubbo";
    }

    public ThreadPoolAdapterState getThreadPoolState(String identify) {
        ThreadPoolAdapterState threadPoolAdapterState = new ThreadPoolAdapterState();
        ThreadPoolExecutor executor = this.DUBBO_PROTOCOL_EXECUTOR.get(identify);
        if (executor == null) {
            log.warn("[{}] Dubbo consuming thread pool not found.", (Object)identify);
            return threadPoolAdapterState;
        }
        threadPoolAdapterState.setThreadPoolKey(identify);
        threadPoolAdapterState.setCoreSize(Integer.valueOf(executor.getCorePoolSize()));
        threadPoolAdapterState.setMaximumSize(Integer.valueOf(executor.getMaximumPoolSize()));
        return threadPoolAdapterState;
    }

    public List<ThreadPoolAdapterState> getThreadPoolStates() {
        ArrayList<ThreadPoolAdapterState> threadPoolAdapterStates = new ArrayList<ThreadPoolAdapterState>();
        this.DUBBO_PROTOCOL_EXECUTOR.forEach((kel, val) -> threadPoolAdapterStates.add(this.getThreadPoolState(String.valueOf(val))));
        return threadPoolAdapterStates;
    }

    public boolean updateThreadPool(ThreadPoolAdapterParameter threadPoolAdapterParameter) {
        String threadPoolKey = threadPoolAdapterParameter.getThreadPoolKey();
        ThreadPoolExecutor executor = this.DUBBO_PROTOCOL_EXECUTOR.get(threadPoolAdapterParameter.getThreadPoolKey());
        if (executor == null) {
            log.warn("[{}] Dubbo consuming thread pool not found.", (Object)threadPoolKey);
            return false;
        }
        int originalCoreSize = executor.getCorePoolSize();
        int originalMaximumPoolSize = executor.getMaximumPoolSize();
        executor.setCorePoolSize(threadPoolAdapterParameter.getCorePoolSize());
        executor.setMaximumPoolSize(threadPoolAdapterParameter.getMaximumPoolSize());
        log.info("[{}] Dubbo consumption thread pool parameter change. coreSize: {}, maximumSize: {}", new Object[]{threadPoolKey, String.format("%s => %s", originalCoreSize, executor.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, executor.getMaximumPoolSize())});
        return true;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        boolean isLegacyVersion = false;
        String poolKey = ExecutorService.class.getName();
        if (Version.getIntVersion((String)Version.getVersion()) < 2070500) {
            isLegacyVersion = true;
        }
        try {
            if (isLegacyVersion) {
                DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
                Map executors = dataStore.get(poolKey);
                executors.forEach((key, value) -> this.DUBBO_PROTOCOL_EXECUTOR.put((String)key, (ThreadPoolExecutor)value));
                return;
            }
            ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
            ConcurrentMap data = (ConcurrentMap)ReflectUtil.getFieldValue((Object)executorRepository, (String)"data");
            ConcurrentMap executorServiceMap = (ConcurrentMap)data.get(poolKey);
            executorServiceMap.forEach((key, value) -> this.DUBBO_PROTOCOL_EXECUTOR.put(String.valueOf(key), (ThreadPoolExecutor)value));
        }
        catch (Exception ex) {
            log.error("Failed to get Dubbo {}.X protocol thread pool", (Object)(isLegacyVersion ? "2" : "3"), (Object)ex);
        }
    }
}

