/*
 * Decompiled with CFR 0.152.
 */
package cn.hiapi.socket.client.protocol;

import cn.hiapi.socket.client.protocol.ProtocolUtils;
import cn.hiapi.socket.client.protocol.data.PackageData;
import cn.hiapi.socket.client.protocol.enums.ProtocolType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Package {
    public static final int MSG_COMPRESS_ROUTE_MASK = 1;
    public static final int MSG_TYPE_MASK = 7;
    public static final int PKG_HEAD_BYTES = 4;
    public static final int MSG_FLAG_BYTES = 1;
    public static final int MSG_ROUTE_LEN_BYTES = 1;

    public static byte[] encode(ProtocolType type, byte[] body) {
        int length = body != null ? body.length : 0;
        byte[] buffer = new byte[4 + length];
        int index = 0;
        buffer[index++] = (byte)(type.getType() & 0xFF);
        buffer[index++] = (byte)(length >> 16 & 0xFF);
        buffer[index++] = (byte)(length >> 8 & 0xFF);
        buffer[index++] = (byte)(length & 0xFF);
        if (body != null) {
            ProtocolUtils.copyArray(buffer, index, body, 0, length);
        }
        return buffer;
    }

    public static List<PackageData> decode(byte[] bytes) {
        int length;
        ArrayList<PackageData> list = new ArrayList<PackageData>();
        for (int offset = 0; offset < bytes.length; offset += length) {
            byte type = bytes[offset++];
            byte[] lengthBytes = new byte[]{0, bytes[offset++], bytes[offset++], bytes[offset++]};
            length = ByteBuffer.wrap(lengthBytes).getInt();
            byte[] body = new byte[length];
            ProtocolUtils.copyArray(body, 0, bytes, offset, length);
            list.add(new PackageData(ProtocolType.valueOf(type), body));
        }
        return list;
    }

    public static byte[] hexToBytes(String hexString) {
        int length = hexString.length();
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return bytes;
    }

    public static void main(String[] args) {
        String hex = "0400008804047b22636f6465223a3838303130313130362c226d657373616765223a2276656d2e6f70656e5f6170692e6465766963652e6e6f745f657869737473222c2264617461223a7b226465766963654964223a22222c22646964223a22222c226d6964223a22222c22646576696365436f6465223a22222c226465766963654e616d65223a22227d7d";
        byte[] encode = Package.hexToBytes(hex);
        List<PackageData> data = Package.decode(encode);
        System.out.println(data);
    }
}

