/*
 * Decompiled with CFR 0.152.
 */
package cn.hiapi.socket.client.protocol;

import cn.hiapi.socket.client.protocol.Protocol;
import cn.hiapi.socket.client.protocol.ProtocolUtils;
import cn.hiapi.socket.client.protocol.data.MessageData;
import cn.hiapi.socket.client.protocol.enums.MessageType;

public class Message {
    public static byte[] encode(long id, MessageType type, String route, byte[] msg) {
        int idBytes = ProtocolUtils.msgHashId(type) ? ProtocolUtils.caculateMsgIdBytes(id) : 0;
        int msgLen = 1 + idBytes;
        byte[] data = new byte[]{};
        if (ProtocolUtils.msgHasRoute(type)) {
            ++msgLen;
            if (route != null && !route.isEmpty()) {
                data = Protocol.strencode(route);
                if (data.length > 255) {
                    throw new RuntimeException("route maxlength is overflow");
                }
                msgLen += data.length;
            }
        }
        if (msg != null) {
            msgLen += msg.length;
        }
        byte[] buffer = new byte[msgLen];
        int offset = 0;
        offset = Message.encodeMsgFlag(type, buffer, offset);
        if (ProtocolUtils.msgHasId(type)) {
            offset = Message.encodeMsgId(id, buffer, offset);
        }
        if (ProtocolUtils.msgHasRoute(type)) {
            offset = Message.encodeMsgRoute(data, buffer, offset);
        }
        if (msg != null) {
            offset = Message.encodeMsgBody(msg, buffer, offset);
        }
        return buffer;
    }

    public static MessageData decode(byte[] bytes) {
        int bytesLen = bytes.length;
        int offset = 0;
        long id = 0L;
        String route = null;
        byte flag = bytes[offset++];
        int compressRoute = flag & 1;
        int type = flag >> 1 & 7;
        MessageType msgType = MessageType.valueOf(type);
        if (ProtocolUtils.msgHashId(msgType)) {
            byte m = bytes[offset];
            int i = 0;
            do {
                m = bytes[offset];
                id = (long)((double)id + (double)(m & 0x7F) * Math.pow(2.0, 7 * i));
                ++offset;
                ++i;
            } while (m >= 128);
        }
        if (ProtocolUtils.msgHasRoute(msgType)) {
            byte routeLen;
            if ((routeLen = bytes[offset++]) > 0) {
                byte[] routeArr = new byte[routeLen];
                ProtocolUtils.copyArray(routeArr, 0, bytes, offset, routeLen);
                route = Protocol.strdecode(routeArr);
            } else {
                route = "";
            }
            offset += routeLen;
        }
        int bodyLen = bytesLen - offset;
        byte[] body = new byte[bodyLen];
        ProtocolUtils.copyArray(body, 0, bytes, offset, bodyLen);
        return new MessageData(id, msgType, route, body);
    }

    private static int encodeMsgBody(byte[] msg, byte[] buffer, int offset) {
        ProtocolUtils.copyArray(buffer, offset, msg, 0, msg.length);
        return offset + msg.length;
    }

    private static int encodeMsgRoute(byte[] data, byte[] buffer, int offset) {
        if (data != null) {
            buffer[offset++] = (byte)(data.length & 0xFF);
            ProtocolUtils.copyArray(buffer, offset, data, 0, data.length);
            offset += data.length;
        } else {
            buffer[offset++] = 0;
        }
        return offset;
    }

    private static int encodeMsgId(long id, byte[] buffer, int offset) {
        long next;
        do {
            long tmp = id % 128L;
            next = (long)Math.floor((double)id / 128.0);
            if (next != 0L) {
                tmp += 128L;
            }
            buffer[offset++] = (byte)tmp;
        } while ((id = next) != 0L);
        return offset;
    }

    private static int encodeMsgFlag(MessageType type, byte[] buffer, int offset) {
        if (type != MessageType.TYPE_REQUEST && type != MessageType.TYPE_NOTIFY && type != MessageType.TYPE_RESPONSE && type != MessageType.TYPE_PUSH) {
            throw new RuntimeException("unkonw message type: " + (Object)((Object)type));
        }
        buffer[offset] = (byte)(type.getType() << 1);
        return offset + 1;
    }
}

