/*
 * Decompiled with CFR 0.152.
 */
package cn.hiapi.socket.client.handlers.impl;

import cn.hiapi.socket.client.handlers.RequestCallback;
import cn.hiapi.socket.client.handlers.SocketHandler;
import cn.hiapi.socket.client.protocol.data.MessageResponse;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class DefaultSocketHandler<Resp>
implements SocketHandler {
    private final RequestCallback<Resp> callback;
    private final Type dataClass;

    public DefaultSocketHandler(RequestCallback<Resp> callback) {
        Type[] typeArguments;
        if (callback == null) {
            throw new RuntimeException("callback can not be null");
        }
        Type[] types = callback.getClass().getGenericInterfaces();
        if (types.length != 1) {
            throw new RuntimeException("callback interfaces length != 1");
        }
        if (types[0] instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)types[0];
            typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length <= 0) {
                throw new RuntimeException("typeArguments length != 0");
            }
        } else {
            throw new RuntimeException("callback interfaces length != 0");
        }
        this.dataClass = typeArguments[0];
        this.callback = callback;
    }

    @Override
    public void onHandler(String msg) {
        try {
            TypeReference<MessageResponse<Object>> typeReference = new TypeReference<MessageResponse<Object>>(){};
            MessageResponse response = (MessageResponse)JSON.parseObject((String)msg, (TypeReference)typeReference, (JSONReader.Feature[])new JSONReader.Feature[0]);
            if (response.getData() == null) {
                MessageResponse messageResponse = new MessageResponse();
                messageResponse.setCode(response.getCode());
                messageResponse.setMessage(response.getMessage());
                this.callback.onResponse(messageResponse);
            } else {
                Object resp = JSON.parseObject((String)response.getData().toString(), (Type)this.dataClass);
                MessageResponse<Object> messageResponse = new MessageResponse<Object>();
                messageResponse.setCode(response.getCode());
                messageResponse.setMessage(response.getMessage());
                messageResponse.setData(resp);
                this.callback.onResponse(messageResponse);
            }
        }
        catch (Exception e) {
            this.callback.onError(e);
        }
    }
}

