/*
 * Decompiled with CFR 0.152.
 */
package cn.hiapi.socket.client;

import cn.hiapi.socket.client.handlers.ContentStateCallback;
import cn.hiapi.socket.client.handlers.RequestCallback;
import cn.hiapi.socket.client.handlers.SocketHandler;
import cn.hiapi.socket.client.handlers.impl.DefaultSocketHandler;
import cn.hiapi.socket.client.protocol.Message;
import cn.hiapi.socket.client.protocol.Package;
import cn.hiapi.socket.client.protocol.Protocol;
import cn.hiapi.socket.client.protocol.data.Handshake;
import cn.hiapi.socket.client.protocol.data.MessageData;
import cn.hiapi.socket.client.protocol.data.PackageData;
import cn.hiapi.socket.client.protocol.enums.MessageType;
import cn.hiapi.socket.client.protocol.enums.ProtocolType;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient {
    private static final Logger log = LoggerFactory.getLogger(SocketClient.class);
    private final String url;
    private final OkHttpClient client;
    private ScheduledExecutorService scheduler;
    private final ContentStateCallback stateCallback;
    private WebSocket socket;
    private long heartbeatNowTime;
    private long heartbeatTimeout;
    private int state;
    private final AtomicInteger reqIndex = new AtomicInteger(0);
    private final Map<String, SocketHandler> handlers = new ConcurrentHashMap<String, SocketHandler>();
    private final Map<Long, String> routeMap = new ConcurrentHashMap<Long, String>();

    public SocketClient(String url, ContentStateCallback stateCallback) {
        this.url = url;
        this.client = new OkHttpClient.Builder().build();
        this.stateCallback = stateCallback;
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::reconnect, 1L, 1L, TimeUnit.SECONDS);
    }

    public void disconnect() {
        if (this.socket != null) {
            this.socket.close(1008, "\u4e3b\u52a8\u5173\u95ed");
        }
    }

    public void connect() {
        this.state = 1;
        log.info("[WebSocket] \u53d1\u8d77\u8fde\u63a5");
        this.heartbeatNowTime = System.currentTimeMillis();
        this.socket = this.client.newWebSocket(new Request.Builder().url(this.url).build(), new WebSocketListener(){

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                SocketClient.this.onClose(code, reason);
            }

            public void onMessage(@NotNull WebSocket socket, @NotNull ByteString bytes) {
                SocketClient.this.onMessage(bytes.toByteArray());
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                SocketClient.this.onOpen();
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                log.warn("[WebSocket] \u5f02\u5e38\u5904\u7406      ", t);
                try {
                    webSocket.close(1009, "");
                }
                catch (Exception e) {
                    log.error("[WebSocket] \u5f02\u5e38\u5904\u7406     \u5173\u95ed\u8fde\u63a5\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                }
                SocketClient.this.onClose(500, t.getMessage());
            }
        });
    }

    private void onOpen() {
        log.info("[WebSocket] \u5efa\u7acb\u8fde\u63a5");
        this.state = 2;
        this.heartbeatNowTime = System.currentTimeMillis();
        String socketType = "JDK-WebSocket";
        String VERSION = "0.0.1";
        JSONObject user = new JSONObject();
        user.put((Object)"created_at", (Object)System.currentTimeMillis());
        byte[] body = Protocol.strencode(new Handshake(socketType, VERSION, user).toString());
        body = Package.encode(ProtocolType.TYPE_HANDSHAKE, body);
        this.sendMsg(body);
    }

    private void onMessage(byte[] array) {
        this.heartbeatNowTime = System.currentTimeMillis();
        List<PackageData> packageList = Package.decode(array);
        for (PackageData data : packageList) {
            this.processPackage(data);
        }
    }

    private void processPackage(PackageData packageData) {
        switch (packageData.getType()) {
            case TYPE_HANDSHAKE: {
                this.sendMsg(Package.encode(ProtocolType.TYPE_HANDSHAKE_ACK, null));
                this.startHeartbeat(packageData.getBody());
                this.stateCallback.onStateChanged(this, ContentStateCallback.State.CONNECT);
                break;
            }
            case TYPE_DATA: {
                SocketHandler handler;
                MessageData msg = Message.decode(packageData.getBody());
                if (msg.getId() > 0L) {
                    msg.setRoute(this.routeMap.remove(msg.getId()));
                    handler = this.handlers.remove(msg.getRoute());
                } else {
                    if (msg.getRoute() == null) {
                        return;
                    }
                    handler = this.handlers.get(msg.getRoute());
                }
                if (handler == null) {
                    log.warn("[WebSocket] processPackage Data \u6ca1\u6709\u6d88\u606f\u56de\u8c03\u4e8b\u4ef6\u65b9\u6cd5 \u6d88\u606f\u5185\u5bb9 id:{} route:{} \u5185\u5bb9\uff1a{}", new Object[]{msg.getId(), msg.getRoute(), new String(msg.getBody())});
                    return;
                }
                String body = Protocol.strdecode(msg.getBody());
                handler.onHandler(body);
                break;
            }
            case TYPE_HEARTBEAT: {
                this.sendMsg(Package.encode(ProtocolType.TYPE_HEARTBEAT, null));
            }
        }
    }

    private void onClose(int code, String reason) {
        log.info("[WebSocket] \u65ad\u94fe code\uff1a{}  {}", (Object)code, (Object)reason);
        this.stateCallback.onStateChanged(this, ContentStateCallback.State.CLOSE);
        this.state = 3;
    }

    private void sendMsg(byte[] bytes) {
        if (this.socket == null) {
            throw new RuntimeException("\u8fd8\u6ca1\u4e0e\u670d\u52a1\u7aef\u8fde\u63a5\u6210\u529f");
        }
        if (this.state != 2) {
            throw new RuntimeException("\u8fd8\u6ca1\u5efa\u7acb\u8fde\u63a5\u6210\u529f");
        }
        this.socket.send(ByteString.of((byte[])bytes));
    }

    private void startHeartbeat(byte[] body) {
        String strdecode = Protocol.strdecode(body);
        Handshake handshake = (Handshake)JSON.parseObject((String)strdecode, Handshake.class);
        Handshake.ProtocolSys sys = handshake.getSys();
        if (sys == null) {
            sys = new Handshake.ProtocolSys();
            sys.setHeartbeat(10L);
        }
        long heartbeatInterval = sys.getHeartbeat();
        this.heartbeatTimeout = heartbeatInterval * 2L;
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        log.info("[WebSocket] \u542f\u52a8\u5fc3\u8df3\u4efb\u52a1 \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4\uff1a{}s, \u5fc3\u8df3\u95f4\u9694\u65f6\u95f4\uff1a{}s", (Object)this.heartbeatTimeout, (Object)heartbeatInterval);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(this::heartbeatHandler, 0L, heartbeatInterval, TimeUnit.SECONDS);
    }

    private void heartbeatHandler() {
        if (this.socket == null) {
            log.info("[WebSocket] \u5fc3\u8df3\u5904\u7406  \u8fd8\u4e3a\u4e0e\u670d\u52a1\u7aef\u8fdb\u884c\u8fde\u63a5");
            return;
        }
        long timeout = (System.currentTimeMillis() - this.heartbeatNowTime) / 1000L;
        if (timeout > this.heartbeatTimeout) {
            log.info("[WebSocket] \u8d85\u65f6\u6ca1\u6709\u5fc3\u8df3\u65ad\u5f00\u8fde\u63a5 \u8d85\u65f6\u65f6\u95f4\uff1a{}s", (Object)timeout);
            this.disconnect();
        }
    }

    private void reconnect() {
        if (this.state == 3) {
            log.info("[WebSocket] 5\u79d2\u540e\u8fdb\u884c\u91cd\u8fde");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connect();
        }
    }

    public <Req, Resp> void request(String route, Req msg, RequestCallback<Resp> callback) {
        try {
            if (route == null || route.isEmpty()) {
                return;
            }
            long reqId = this.reqIndex.addAndGet(1);
            this.sendMessage(reqId, route, msg);
            this.handlers.put(route, new DefaultSocketHandler<Resp>(callback));
            this.routeMap.put(reqId, route);
        }
        catch (Exception e) {
            callback.onError(e);
        }
    }

    public <Req> void notify(String route, Req msg) {
        this.sendMessage(0L, route, msg);
    }

    public <Resp> void on(String route, RequestCallback<Resp> callback) {
        this.handlers.put(route, new DefaultSocketHandler<Resp>(callback));
    }

    private <Req> void sendMessage(long reqId, String route, Req msg) {
        MessageType type = reqId > 0L ? MessageType.TYPE_REQUEST : MessageType.TYPE_NOTIFY;
        byte[] body = Protocol.strencode(JSON.toJSONString(msg));
        byte[] message = Message.encode(reqId, type, route, body);
        byte[] packet = Package.encode(ProtocolType.TYPE_DATA, message);
        this.sendMsg(packet);
    }
}

