package cn.hex01.billing.open.sdk.util;

import lombok.SneakyThrows;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

/**
 * @author laoji
 */
public abstract class SignUtil {
    private static final String ALGORITHM = "SHA256withRSA";

    /**
     * 签名
     *
     * @param text
     * @param privateKey
     * @return
     */
    @SneakyThrows
    public static String sign(String text, String privateKey) {
        Signature signature = Signature.getInstance(ALGORITHM);
        signature.initSign(getPrivateKey(privateKey));
        signature.update(text.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    /**
     * 验签
     *
     * @param text
     * @param publicKey
     * @param sign
     * @return
     */
    @SneakyThrows
    public static boolean verify(String text, String publicKey, String sign) {
        Signature signature = Signature.getInstance(ALGORITHM);
        signature.initVerify(getPublicKey(publicKey));
        signature.update(text.getBytes(StandardCharsets.UTF_8));
        return signature.verify(Base64.getDecoder().decode(sign));
    }

    private static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    private static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }
}
