package cn.hex01.billing.open.sdk.interceptor;

import cn.hex01.billing.open.sdk.dto.vo.ErrorMessageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import com.google.gson.Gson;
import feign.FeignException;
import feign.InvocationContext;
import feign.ResponseInterceptor;
import feign.codec.StringDecoder;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;

/**
 * @author laoji
 */
public class CustomResponseInterceptor implements ResponseInterceptor {
    public static final Gson GSON = new Gson();

    @Override
    public Object intercept(InvocationContext invocationContext, Chain chain) throws Exception {
        var response = invocationContext.response();
        var status = response.status();
        if (status == 200) {
            return invocationContext.decoder().decode(response, invocationContext.returnType());
        }

        if (response.status() == 400) {
            var errorMessage = (ErrorMessageVo) invocationContext.decoder().decode(response, ErrorMessageVo.class);
            throw new BillingBusinessException(errorMessage);
        }

        var request = response.request();
        var requestHeaders = request.headers();
        Object requestData = null;
        switch (request.httpMethod()) {
            case GET:
            case DELETE: {
                requestData = request.requestTemplate().queries();
                break;
            }
            case POST:
            case PUT:
            case PATCH: {
                requestData = new String(response.request().body(), StandardCharsets.UTF_8);
                break;
            }
        }
        var responseHeaders = response.headers();
        var responseBody = new StringDecoder().decode(response, String.class);

        var errorMsgMap = new HashMap<String, Object>();
        errorMsgMap.put("requestHeaders", requestHeaders);
        errorMsgMap.put("requestData", requestData);
        errorMsgMap.put("responseHeaders", responseHeaders);
        errorMsgMap.put("responseBody", responseBody);

        throw FeignException.errorStatus(GSON.toJson(errorMsgMap), response);
    }

    @Override
    public ResponseInterceptor andThen(ResponseInterceptor nextInterceptor) {
        return ResponseInterceptor.super.andThen(nextInterceptor);
    }

    @Override
    public Chain apply(Chain chain) {
        return ResponseInterceptor.super.apply(chain);
    }
}
