package cn.hex01.billing.open.sdk.interceptor;

import cn.hex01.billing.open.sdk.config.ApiConfig;
import cn.hex01.billing.open.sdk.util.SignUtil;
import com.google.gson.Gson;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.RequiredArgsConstructor;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;

/**
 * @author laoji
 */
@RequiredArgsConstructor
public class CustomRequestInterceptor implements RequestInterceptor {
    public static final Gson GSON = new Gson();
    private final ApiConfig config;

    @Override
    public void apply(RequestTemplate template) {
        var extUserId = "";
        var timestamp = System.currentTimeMillis();

        switch (template.request().httpMethod()) {
            case GET:
            case DELETE: {
                extUserId = template.queries().get("extUserId").iterator().next();

                template.query("appId", this.config.getAppId());
                if (template.queries().containsKey("timestamp")) {
                    timestamp = Long.parseLong(template.queries().get("timestamp").iterator().next());
                } else {
                    template.query("timestamp", String.valueOf(timestamp));
                }
                break;
            }
            case POST:
            case PUT:
            case PATCH: {
                var body = GSON.fromJson(new String(template.body(), StandardCharsets.UTF_8), HashMap.class);
                extUserId = body.get("extUserId").toString();

                body.put("appId", this.config.getAppId());
                if (body.containsKey("timestamp")) {
                    timestamp = ((Double) body.get("timestamp")).longValue();
                } else {
                    body.put("timestamp", timestamp);
                }
                template.body(GSON.toJson(body));
                break;
            }
        }

        template.header("X-Sign", this.sign(extUserId, timestamp));
    }

    /**
     * 签名
     * 算法：base64(SHA256withRSA(${appId}_${extUserId}_${timestamp}))
     *
     * @param extUserId
     * @param timestamp
     * @return
     */
    private String sign(String extUserId, long timestamp) {
        if (this.config.getPrivateKey().isEmpty()) {
            return "";
        }

        var text = this.config.getAppId() + "_" +
                extUserId + "_" +
                timestamp;
        return SignUtil.sign(text, this.config.getPrivateKey());
    }
}
