package cn.hex01.billing.open.sdk.dto.vo;

import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.List;

/**
 * 分页结果
 *
 * @author laoji
 */
@Getter
// 因有泛型无法使用builder
//@Builder
@RequiredArgsConstructor
public class PageVo<T> {
    /**
     * totalElements
     */
    @NonNull
    private final Long totalElements;
    /**
     * totalPages
     */
    @NonNull
    private final Integer totalPages;
    /**
     * pageNum
     * 从1开始
     */
    @NonNull
    private final Integer pageNum;
    /**
     * pageSize
     */
    @NonNull
    private final Integer pageSize;
    /**
     * content
     */
    @NonNull
    private final List<T> content;
}
