package cn.hex01.billing.open.sdk.dto.q.vo;

import lombok.Getter;
import lombok.NonNull;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * 配额（有效期+额度）
 *
 * @author laoji
 */
@Getter
@SuperBuilder
public class QuotaVo extends BaseQuotaVo {
    /**
     * 使用量
     */
    @NonNull
    private final Long usage;
    /**
     * 额度
     */
    @NonNull
    private final Long limit;
    /**
     * 有效期
     * 所有配额项均失效时为null
     */
    private final String expiryDate;
    /**
     * 配额项
     */
    @NonNull
    private final List<QuotaItemVo> items;
}
