package cn.hex01.billing.open.sdk.dto.pr.vo;

import lombok.Getter;
import lombok.NonNull;
import lombok.experimental.SuperBuilder;

/**
 * 有效配额购买记录（仅有效期）
 *
 * @author laoji
 */
@Getter
@SuperBuilder
public class ValidityPurchaseRecordVo extends BasePurchaseRecordVo {
    /**
     * 原有效期
     * 第一次购买时为空
     */
    private final String originalExpiryDate;
    /**
     * 现有效期
     */
    @NonNull
    private final String expiryDate;
    /**
     * 时段
     */
    @NonNull
    private final PeriodVo period;
}
