package cn.hex01.billing.open.sdk.dto.pr.vo;

import lombok.Getter;
import lombok.NonNull;
import lombok.experimental.SuperBuilder;

/**
 * 配额购买记录（有效期+额度）
 *
 * @author laoji
 */
@Getter
@SuperBuilder
public class PurchaseRecordVo extends BasePurchaseRecordVo {
    /**
     * 配额项id
     */
    @NonNull
    private final String quotaItemId;
    /**
     * 原额度
     */
    @NonNull
    private final Long originalLimit;
    /**
     * 现额度
     */
    @NonNull
    private final Long limit;
    /**
     * 原有效期
     * 第一次购买时为空
     */
    private final String originalExpiryDate;
    /**
     * 现有效期
     */
    @NonNull
    private final String expiryDate;
    /**
     * 时段
     */
    @NonNull
    private final PeriodVo period;
}
