package cn.hex01.billing.open.sdk.api.vq;

import cn.hex01.billing.open.sdk.dto.pr.ValidityPurchaseRecordQueryingDto;
import cn.hex01.billing.open.sdk.dto.pr.vo.ValidityPurchaseRecordVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_VALIDITY_QUOTA_URI_PREFIX;

/**
 * 有效配额购买记录（仅有效期）
 *
 * @author laoji
 */
public interface ValidityPurchaseRecordApi {
    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_VALIDITY_QUOTA_URI_PREFIX + "/purchase_records")
    PageVo<ValidityPurchaseRecordVo> query(@QueryMap ValidityPurchaseRecordQueryingDto dto) throws BillingBusinessException;
}
