package cn.hex01.billing.open.sdk.api.q;

import cn.hex01.billing.open.sdk.dto.ur.UsageRecordQueryingDto;
import cn.hex01.billing.open.sdk.dto.ur.vo.UsageRecordVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_QUOTA_URI_PREFIX;

/**
 * 配额使用记录（有效期+额度）
 *
 * @author laoji
 */
public interface UsageRecordApi {
    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_QUOTA_URI_PREFIX + "/usage_records")
    PageVo<UsageRecordVo> query(@QueryMap UsageRecordQueryingDto dto) throws BillingBusinessException;
}
