package cn.hex01.billing.open.sdk.api.q;

import cn.hex01.billing.open.sdk.dto.q.*;
import cn.hex01.billing.open.sdk.dto.q.vo.QuotaCapacityAdjustmentRecordVo;
import cn.hex01.billing.open.sdk.dto.q.vo.QuotaVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.Headers;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_QUOTA_URI_PREFIX;

/**
 * 配额（有效期+额度）
 *
 * @author laoji
 */
public interface QuotaApi {
    /**
     * 充值
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + V1_QUOTA_URI_PREFIX + "/charge")
    void charge(QuotaChargingDto dto) throws BillingBusinessException;

    /**
     * 消费
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @Headers("Content-Type: application/json")
    @RequestLine("PATCH " + V1_QUOTA_URI_PREFIX + "/consumption")
    void consume(QuotaConsumingDto dto) throws BillingBusinessException;

    /**
     * 调整容量
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @Headers("Content-Type: application/json")
    @RequestLine("PATCH " + V1_QUOTA_URI_PREFIX + "/capacity")
    void adjustCapacity(QuotaCapacityAdjustingDto dto) throws BillingBusinessException;

    /**
     * 检查
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_QUOTA_URI_PREFIX + "/check")
    void check(@QueryMap QuotaCheckingDto dto) throws BillingBusinessException;

    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_QUOTA_URI_PREFIX)
    PageVo<QuotaVo> query(@QueryMap QuotaQueryingDto dto) throws BillingBusinessException;

    /**
     * 查询容量调整记录
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_QUOTA_URI_PREFIX + "/capacity_adjustment_record")
    PageVo<QuotaCapacityAdjustmentRecordVo> queryCapacityAdjustmentRecord(
            @QueryMap QuotaCapacityAdjustmentRecordQueryingDto dto) throws BillingBusinessException;
}
