package cn.hex01.billing.open.sdk.api.q;

import cn.hex01.billing.open.sdk.dto.pr.PurchaseRecordQueryingDto;
import cn.hex01.billing.open.sdk.dto.pr.vo.PurchaseRecordVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_QUOTA_URI_PREFIX;

/**
 * 配额购买记录（有效期+额度）
 *
 * @author laoji
 */
public interface PurchaseRecordApi {
    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_QUOTA_URI_PREFIX + "/purchase_records")
    PageVo<PurchaseRecordVo> query(@QueryMap PurchaseRecordQueryingDto dto) throws BillingBusinessException;
}
