package cn.hex01.billing.open.sdk.api.lq;

import cn.hex01.billing.open.sdk.dto.ur.LimitUsageRecordQueryingDto;
import cn.hex01.billing.open.sdk.dto.ur.vo.LimitUsageRecordVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_LIMIT_QUOTA_URI_PREFIX;

/**
 * 用量配额使用记录（仅额度）
 *
 * @author laoji
 */
public interface LimitUsageRecordApi {
    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_LIMIT_QUOTA_URI_PREFIX + "/usage_records")
    PageVo<LimitUsageRecordVo> query(@QueryMap LimitUsageRecordQueryingDto dto) throws BillingBusinessException;
}
