package cn.hex01.billing.open.sdk.api.lq;

import cn.hex01.billing.open.sdk.dto.q.*;
import cn.hex01.billing.open.sdk.dto.q.vo.LimitQuotaVo;
import cn.hex01.billing.open.sdk.dto.q.vo.QuotaCapacityAdjustmentRecordVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.Headers;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_LIMIT_QUOTA_URI_PREFIX;

/**
 * 用量配额（仅额度）
 *
 * @author laoji
 */
public interface LimitQuotaApi {
    /**
     * 充值
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + V1_LIMIT_QUOTA_URI_PREFIX + "/charge")
    void charge(LimitQuotaChargingDto dto) throws BillingBusinessException;

    /**
     * 消费
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @Headers("Content-Type: application/json")
    @RequestLine("PATCH " + V1_LIMIT_QUOTA_URI_PREFIX + "/consumption")
    void consume(LimitQuotaConsumingDto dto) throws BillingBusinessException;

    /**
     * 调整容量
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @Headers("Content-Type: application/json")
    @RequestLine("PATCH " + V1_LIMIT_QUOTA_URI_PREFIX + "/capacity")
    void adjustCapacity(QuotaCapacityAdjustingDto dto) throws BillingBusinessException;

    /**
     * 检查
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_LIMIT_QUOTA_URI_PREFIX + "/check")
    void check(@QueryMap LimitQuotaCheckingDto dto) throws BillingBusinessException;

    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_LIMIT_QUOTA_URI_PREFIX)
    PageVo<LimitQuotaVo> query(@QueryMap LimitQuotaQueryingDto dto) throws BillingBusinessException;

    /**
     * 查询容量调整记录
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_LIMIT_QUOTA_URI_PREFIX + "/capacity_adjustment_record")
    PageVo<QuotaCapacityAdjustmentRecordVo> queryCapacityAdjustmentRecord(
            @QueryMap QuotaCapacityAdjustmentRecordQueryingDto dto) throws BillingBusinessException;
}
