package cn.hex01.billing.open.sdk.api.lq;


import cn.hex01.billing.open.sdk.dto.pr.LimitPurchaseRecordQueryingDto;
import cn.hex01.billing.open.sdk.dto.pr.vo.LimitPurchaseRecordVo;
import cn.hex01.billing.open.sdk.dto.vo.PageVo;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_LIMIT_QUOTA_URI_PREFIX;

/**
 * 用量配额购买记录（仅额度）
 *
 * @author laoji
 */
public interface LimitPurchaseRecordApi {
    /**
     * 查询
     *
     * @param dto
     * @return
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_LIMIT_QUOTA_URI_PREFIX + "/purchase_records")
    PageVo<LimitPurchaseRecordVo> query(@QueryMap LimitPurchaseRecordQueryingDto dto) throws BillingBusinessException;
}
