package cn.hex01.billing.open.sdk.api.a;

import cn.hex01.billing.open.sdk.dto.a.AccountDeletingDto;
import cn.hex01.billing.open.sdk.dto.a.AccountExistenceCheckingDto;
import cn.hex01.billing.open.sdk.exception.BillingBusinessException;
import feign.QueryMap;
import feign.RequestLine;

import static cn.hex01.billing.open.sdk.util.ConstantUtil.V1_ACCOUNT_URI_PREFIX;

/**
 * 账户
 *
 * @author laoji
 */
public interface AccountApi {
    /**
     * 检查是否存在
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @RequestLine("GET " + V1_ACCOUNT_URI_PREFIX + "/existence")
    void checkExistence(@QueryMap AccountExistenceCheckingDto dto) throws BillingBusinessException;

    /**
     * 删除
     *
     * @param dto
     * @throws BillingBusinessException
     */
    @RequestLine("DELETE " + V1_ACCOUNT_URI_PREFIX)
    void delete(@QueryMap AccountDeletingDto dto) throws BillingBusinessException;
}
