/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.tsdb.influxdb.properties;

import cn.herodotus.stirrup.tsdb.influxdb.constants.InfluxdbConstants;
import com.google.common.base.MoreObjects;
import org.influxdb.InfluxDB;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.concurrent.TimeUnit;

/**
 * <p>Description: Influxdb 模块 yml 配置参数 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/4 16:19
 */
@ConfigurationProperties(prefix = InfluxdbConstants.PROPERTY_TSDB_INFLUXDB)
public class InfluxdbProperties {

    /**
     * Influxdb 1.X 用户名
     */
    private String username;
    /**
     * Influxdb 1.X 密码
     */
    private String password;
    /**
     * Influxdb 1.X 连接url
     */
    private String url;
    /**
     * 默认数据库
     */
    private String database;
    /**
     * 保留策略。默认值：autogen
     */
    private String retentionPolicy = "autogen";
    /**
     * Influxdb 一致性级别，默认值：one。
     */
    private InfluxDB.ConsistencyLevel consistency = InfluxDB.ConsistencyLevel.ONE;
    /**
     * Influxdb 日志级别，默认值：basic。
     */
    private InfluxDB.LogLevel logLevel = InfluxDB.LogLevel.BASIC;
    /**
     * 开启 Batch 处理设置。一个批次 Point 数量，默认值 100。
     */
    private int actions = 100;
    /**
     * 开启 Batch 处理设置。刷新周期数值
     */
    private int flushDuration = 2000;
    /**
     * 开启 Batch 处理设置。刷新周期单位，默认值：毫秒
     */
    private TimeUnit flushDurationTimeUnit = TimeUnit.MILLISECONDS;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDatabase() {
        return database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getRetentionPolicy() {
        return retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public InfluxDB.ConsistencyLevel getConsistency() {
        return consistency;
    }

    public void setConsistency(InfluxDB.ConsistencyLevel consistency) {
        this.consistency = consistency;
    }

    public InfluxDB.LogLevel getLogLevel() {
        return logLevel;
    }

    public void setLogLevel(InfluxDB.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public int getActions() {
        return actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public int getFlushDuration() {
        return flushDuration;
    }

    public void setFlushDuration(int flushDuration) {
        this.flushDuration = flushDuration;
    }

    public TimeUnit getFlushDurationTimeUnit() {
        return flushDurationTimeUnit;
    }

    public void setFlushDurationTimeUnit(TimeUnit flushDurationTimeUnit) {
        this.flushDurationTimeUnit = flushDurationTimeUnit;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("username", username)
                .add("password", password)
                .add("url", url)
                .add("database", database)
                .add("retentionPolicy", retentionPolicy)
                .add("consistency", consistency)
                .add("logLevel", logLevel)
                .add("actions", actions)
                .add("flushDuration", flushDuration)
                .add("flushDurationTimeUnit", flushDurationTimeUnit)
                .toString();
    }
}
