/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.tsdb.influxdb.converter;

import org.influxdb.dto.QueryResult;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>Description: Influxdb QueryRequest 转 MapList 转换器 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/5 0:00
 */
public class QueryResultToMapListConverter extends AbstractQueryResultToListConverter<Map<String, Object>> {

    @Override
    public List<Map<String, Object>> convert(QueryResult queryResult) {
        List<QueryResult.Result> results = queryResult.getResults();
        return results
                .stream()
                .flatMap(result -> Optional.ofNullable(result.getSeries()).orElse(new ArrayList<>())
                        .stream()
                        .flatMap(series -> Optional.ofNullable(series.getValues()).orElse(new ArrayList<>())
                                .stream()
                                .map(item -> pointToMap(item, series.getColumns(), series.getTags()))))
                .toList();
    }
}
